package com.xforceplus.imageservicesaas.controller;


/**
 * 比对海关报关单明细feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareTicketCustomsDeclarationDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareTicketCustomsDeclarationDetailFeignApi {

  /**
   * 通过id查询比对海关报关单明细
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketCustomsDeclarationDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对海关报关单明细
   * @param compareTicketCustomsDeclarationDetail 比对海关报关单明细
   * @return R
   */
  @PostMapping("/compareTicketCustomsDeclarationDetail/add")
  public R save(@RequestBody CompareTicketCustomsDeclarationDetail compareTicketCustomsDeclarationDetail);

  /**
   * 修改比对海关报关单明细
   * @param compareTicketCustomsDeclarationDetail 比对海关报关单明细
   * @return R
   */
  @PostMapping("/compareTicketCustomsDeclarationDetail/update")
  public R updateById(@RequestBody CompareTicketCustomsDeclarationDetail compareTicketCustomsDeclarationDetail);

  /**
   * 通过id删除比对海关报关单明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketCustomsDeclarationDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}