package com.xforceplus.imageservicesaas.controller;


/**
 * 比对报关单feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareTicketCustomsDeclaration;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareTicketCustomsDeclarationFeignApi {

  /**
   * 通过id查询比对报关单
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketCustomsDeclaration/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对报关单
   * @param compareTicketCustomsDeclaration 比对报关单
   * @return R
   */
  @PostMapping("/compareTicketCustomsDeclaration/add")
  public R save(@RequestBody CompareTicketCustomsDeclaration compareTicketCustomsDeclaration);

  /**
   * 修改比对报关单
   * @param compareTicketCustomsDeclaration 比对报关单
   * @return R
   */
  @PostMapping("/compareTicketCustomsDeclaration/update")
  public R updateById(@RequestBody CompareTicketCustomsDeclaration compareTicketCustomsDeclaration);

  /**
   * 通过id删除比对报关单
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketCustomsDeclaration/del/{id}" )
  public R removeById(@PathVariable Long id);

}