package com.xforceplus.imageservicesaas.controller;


/**
 * 数据比对用途的通用机打发票feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareTicketMachine;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareTicketMachineFeignApi {

  /**
   * 通过id查询数据比对用途的通用机打发票
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketMachine/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的通用机打发票
   * @param compareTicketMachine 数据比对用途的通用机打发票
   * @return R
   */
  @PostMapping("/compareTicketMachine/add")
  public R save(@RequestBody CompareTicketMachine compareTicketMachine);

  /**
   * 修改数据比对用途的通用机打发票
   * @param compareTicketMachine 数据比对用途的通用机打发票
   * @return R
   */
  @PostMapping("/compareTicketMachine/update")
  public R updateById(@RequestBody CompareTicketMachine compareTicketMachine);

  /**
   * 通过id删除数据比对用途的通用机打发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketMachine/del/{id}" )
  public R removeById(@PathVariable Long id);

}