package com.xforceplus.imageservicesaas.controller;


/**
 * 数据比对用途的飞机票feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareTicketPlane;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareTicketPlaneFeignApi {

  /**
   * 通过id查询数据比对用途的飞机票
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketPlane/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的飞机票
   * @param compareTicketPlane 数据比对用途的飞机票
   * @return R
   */
  @PostMapping("/compareTicketPlane/add")
  public R save(@RequestBody CompareTicketPlane compareTicketPlane);

  /**
   * 修改数据比对用途的飞机票
   * @param compareTicketPlane 数据比对用途的飞机票
   * @return R
   */
  @PostMapping("/compareTicketPlane/update")
  public R updateById(@RequestBody CompareTicketPlane compareTicketPlane);

  /**
   * 通过id删除数据比对用途的飞机票
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketPlane/del/{id}" )
  public R removeById(@PathVariable Long id);

}