package com.xforceplus.imageservicesaas.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.FunctionCode;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface FunctionCodeFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/functionCode/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param functionCode ${table.comment}
   * @return R
   */
  @PostMapping("/functionCode/add")
  public R save(@RequestBody FunctionCode functionCode);

  /**
   * 修改${table.comment}
   * @param functionCode ${table.comment}
   * @return R
   */
  @PostMapping("/functionCode/update")
  public R updateById(@RequestBody FunctionCode functionCode);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/functionCode/del/{id}" )
  public R removeById(@PathVariable Long id);

}