package com.xforceplus.imageservicesaas.controller;


/**
 * 进口类发票feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketImport;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface TicketImportFeignApi {

  /**
   * 通过id查询进口类发票
   * @param  id
   * @return R
   */
  @GetMapping("/ticketImport/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增进口类发票
   * @param ticketImport 进口类发票
   * @return R
   */
  @PostMapping("/ticketImport/add")
  public R save(@RequestBody TicketImport ticketImport);

  /**
   * 修改进口类发票
   * @param ticketImport 进口类发票
   * @return R
   */
  @PostMapping("/ticketImport/update")
  public R updateById(@RequestBody TicketImport ticketImport);

  /**
   * 通过id删除进口类发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketImport/del/{id}" )
  public R removeById(@PathVariable Long id);

}