package com.xforceplus.imageservicesaas.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketMany;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface TicketManyFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/ticketMany/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param ticketMany ${table.comment}
   * @return R
   */
  @PostMapping("/ticketMany/add")
  public R save(@RequestBody TicketMany ticketMany);

  /**
   * 修改${table.comment}
   * @param ticketMany ${table.comment}
   * @return R
   */
  @PostMapping("/ticketMany/update")
  public R updateById(@RequestBody TicketMany ticketMany);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketMany/del/{id}" )
  public R removeById(@PathVariable Long id);

}