package com.xforceplus.imageservicesaas.controller;


/**
 * 虚拟单证feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketVirtual;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface TicketVirtualFeignApi {

  /**
   * 通过id查询虚拟单证
   * @param  id
   * @return R
   */
  @GetMapping("/ticketVirtual/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增虚拟单证
   * @param ticketVirtual 虚拟单证
   * @return R
   */
  @PostMapping("/ticketVirtual/add")
  public R save(@RequestBody TicketVirtual ticketVirtual);

  /**
   * 修改虚拟单证
   * @param ticketVirtual 虚拟单证
   * @return R
   */
  @PostMapping("/ticketVirtual/update")
  public R updateById(@RequestBody TicketVirtual ticketVirtual);

  /**
   * 通过id删除虚拟单证
   * @param  id
   * @return R
   */
  @DeleteMapping("/ticketVirtual/del/{id}" )
  public R removeById(@PathVariable Long id);

}