package com.xforceplus.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * http_method
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum HttpMethod {

    GET("GET", "GET"),
    POST("POST", "POST"),
    PUT("PUT", "PUT");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    HttpMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HttpMethod fromCode(String code){
        switch(code) {
            case "GET":
                return GET;
            case "POST":
                return POST;
            case "PUT":
                return PUT;
            default:
                return null;
        }
    }
}
