package com.xforceplus.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * special_invoice_flag
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum SpecialInvoiceFlag {

    _0("0", "无"),
    _1("1", "成品油"),
    _2("2", "通行费（可抵扣）"),
    _3("3", "区块链"),
    _5("5", "建筑服务"),
    _6("6", "货物运输服务"),
    _7("7", "不动产销售"),
    _8("8", "不动产经营租赁服务"),
    _9("9", "旅客运输服务"),
    _28("28", "差额征税-差额开票"),
    _29("29", "差额征税-全额开票"),
    _10("10", "农产品收购"),
    _27("27", "自产农产品销售"),
    _60("60", "金银首饰批发"),
    _61("61", "金银首饰零售");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SpecialInvoiceFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialInvoiceFlag fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "28":
                return _28;
            case "29":
                return _29;
            case "10":
                return _10;
            case "27":
                return _27;
            case "60":
                return _60;
            case "61":
                return _61;
            default:
                return null;
        }
    }
}
