package com.xforceplus.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ticket_rel_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum TicketRelType {

    REPEAT("repeat", "重复关系"),
    SHEET("sheet", "联次关系"),
    SALES("sales", "销货清单关系"),
    SERIES("series", "连号关系"),
    ATTACH("attach", "附件关系");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TicketRelType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketRelType fromCode(String code){
        switch(code) {
            case "repeat":
                return REPEAT;
            case "sheet":
                return SHEET;
            case "sales":
                return SALES;
            case "series":
                return SERIES;
            case "attach":
                return ATTACH;
            default:
                return null;
        }
    }
}
