package com.xforceplus.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * verify_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum VerifyStatus {

    _0("0", "待核验"),
    _2("2", "暂挂起"),
    _1("1", "核验合格"),
    _99("99", "核验不合格");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VerifyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VerifyStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "1":
                return _1;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
