package com.xforceplus.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * voucher_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum VoucherType {

    T("t", "火车票"),
    P("p", "飞机票行程单"),
    BUS("bus", "客运票"),
    WITHHOLD("withhold", "代扣代缴通用缴款书");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VoucherType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VoucherType fromCode(String code){
        switch(code) {
            case "t":
                return T;
            case "p":
                return P;
            case "bus":
                return BUS;
            case "withhold":
                return WITHHOLD;
            default:
                return null;
        }
    }
}
