package com.xforceplus.imageservicesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.imageservicesaas.entity.Ticket;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketHaiwaifapiaozhuxinxi extends Ticket {


  /**
   * 子类型
   */
  private String subtype;

  /**
   * 日期
   */
  private String documentDate;

  /**
   * 消费类型
   */
  private String expenseCategory;

  /**
   * 合计金额
   */
  private String totalAmount;

  /**
   * 合计不含税金额
   */
  private String totalNetAmountExcludingTaxes;

  /**
   * 合计税额
   */
  private String totalTax;

  /**
   * 销售方名称
   */
  private String supplierName;

  /**
   * 购买方名称
   */
  private String customerName;

  /**
   * 购买方类型
   */
  private String customerType;

  /**
   * 币种
   */
  private String currency;

  /**
   * 销方注册地址
   */
  private String supplierAddress;

  /**
   * 消费国家
   */
  private String supplierCountry;

  /**
   * 票据唯一凭证号
   */
  private String documentNumber;

  /**
   * 付款条件
   */
  private String paymentTerms;

  /**
   * 关联的其他单据编号
   */
  private String referenceDocNumber;

  /**
   * 总税率
   */
  private String taxRateTotal;

  /**
   * Due date
   */
  @TableField("dueDate")
  private String dueDate;

  /**
   * 国家
   */
  private String country;

  /**
   * 税务发票开具人姓名
   */
  private String kaijurenName;

  /**
   * 税务发票开具人职务
   */
  private String kaijurenJob;

  /**
   * 税务发票开具人登记号码
   */
  private String kaijurendengjiNo;

  /**
   * 文件接收人姓名
   */
  private String jieshourenName;

  /**
   * 文件接收人职务
   */
  private String jieshourenJob;

  /**
   * 识别率
   */
  private String ocrRate;

  /**
   * 识别完成时间
   */
  private String ocrFinish;

  /**
   * 识别耗时
   */
  private String ocrDuration;

  /**
   * 扩展字段1
   */
  private String haiwaiext1;

  /**
   * 扩展字段2
   */
  private String haiwaiext2;

  /**
   * 扩展字段3
   */
  private String haiwaiext3;

  /**
   * 扩展字段4
   */
  private String haiwaiext4;

  /**
   * 扩展字段5
   */
  private String haiwaiext5;

  /**
   * 扩展字段6
   */
  private String haiwaiext6;

  /**
   * 扩展字段7
   */
  private String haiwaiext7;

  /**
   * 扩展字段8
   */
  private String haiwaiext8;

  /**
   * 扩展字段9
   */
  private String haiwaiext9;

  /**
   * 扩展字段10
   */
  private String haiwaiext10;

  /**
   * 10%税率税额
   */
  private String taxAmount10;

  /**
   * 10%税率不含税金额
   */
  private String amountWithoutTax10;

  /**
   * 10%税率含税金额
   */
  private String amountWithTax10;

  /**
   * 8%税率税额
   */
  private String taxAmount8;

  /**
   * 8%税率不含税金额
   */
  private String amountWithoutTax8;

  /**
   * 8%税率含税金额
   */
  private String amountWithTax8;

  /**
   * 价格方式
   */
  private String jiageMethod;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("subtype", subtype);
      map.put("document_date", documentDate);
      map.put("expense_category", expenseCategory);
      map.put("total_amount", totalAmount);
      map.put("total_net_amount_excluding_taxes", totalNetAmountExcludingTaxes);
      map.put("total_tax", totalTax);
      map.put("supplier_name", supplierName);
      map.put("customer_name", customerName);
      map.put("customer_type", customerType);
      map.put("currency", currency);
      map.put("supplier_address", supplierAddress);
      map.put("supplier_country", supplierCountry);
      map.put("document_number", documentNumber);
      map.put("payment_terms", paymentTerms);
      map.put("reference_doc_number", referenceDocNumber);
      map.put("tax_rate_total", taxRateTotal);
      map.put("dueDate", dueDate);
      map.put("country", country);
      map.put("kaijuren_name", kaijurenName);
      map.put("kaijuren_job", kaijurenJob);
      map.put("kaijurendengji_no", kaijurendengjiNo);
      map.put("jieshouren_name", jieshourenName);
      map.put("jieshouren_job", jieshourenJob);
      map.put("ocr_rate", ocrRate);
      map.put("ocr_finish", ocrFinish);
      map.put("ocr_duration", ocrDuration);
      map.put("haiwaiext_1", haiwaiext1);
      map.put("haiwaiext_2", haiwaiext2);
      map.put("haiwaiext_3", haiwaiext3);
      map.put("haiwaiext_4", haiwaiext4);
      map.put("haiwaiext_5", haiwaiext5);
      map.put("haiwaiext_6", haiwaiext6);
      map.put("haiwaiext_7", haiwaiext7);
      map.put("haiwaiext_8", haiwaiext8);
      map.put("haiwaiext_9", haiwaiext9);
      map.put("haiwaiext_10", haiwaiext10);
      map.put("tax_amount_10", taxAmount10);
      map.put("amount_without_tax_10", amountWithoutTax10);
      map.put("amount_with_tax_10", amountWithTax10);
      map.put("tax_amount_8", taxAmount8);
      map.put("amount_without_tax_8", amountWithoutTax8);
      map.put("amount_with_tax_8", amountWithTax8);
      map.put("jiage_method", jiageMethod);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static TicketHaiwaifapiaozhuxinxi fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketHaiwaifapiaozhuxinxi entity = new TicketHaiwaifapiaozhuxinxi();
    entity.setParentByOQSMap(map);
    if(map.containsKey("subtype")) {
      Object obj = map.get("subtype");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubtype((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_date")) {
      Object obj = map.get("document_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expense_category")) {
      Object obj = map.get("expense_category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_net_amount_excluding_taxes")) {
      Object obj = map.get("total_net_amount_excluding_taxes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalNetAmountExcludingTaxes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_tax")) {
      Object obj = map.get("total_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotalTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplier_name")) {
      Object obj = map.get("supplier_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_type")) {
      Object obj = map.get("customer_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplier_address")) {
      Object obj = map.get("supplier_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplier_country")) {
      Object obj = map.get("supplier_country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_number")) {
      Object obj = map.get("document_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_terms")) {
      Object obj = map.get("payment_terms");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentTerms((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reference_doc_number")) {
      Object obj = map.get("reference_doc_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReferenceDocNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate_total")) {
      Object obj = map.get("tax_rate_total");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRateTotal((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dueDate")) {
      Object obj = map.get("dueDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDueDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kaijuren_name")) {
      Object obj = map.get("kaijuren_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKaijurenName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kaijuren_job")) {
      Object obj = map.get("kaijuren_job");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKaijurenJob((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kaijurendengji_no")) {
      Object obj = map.get("kaijurendengji_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKaijurendengjiNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jieshouren_name")) {
      Object obj = map.get("jieshouren_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJieshourenName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jieshouren_job")) {
      Object obj = map.get("jieshouren_job");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJieshourenJob((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrFinish((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrDuration((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_1")) {
      Object obj = map.get("haiwaiext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_2")) {
      Object obj = map.get("haiwaiext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_3")) {
      Object obj = map.get("haiwaiext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_4")) {
      Object obj = map.get("haiwaiext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_5")) {
      Object obj = map.get("haiwaiext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_6")) {
      Object obj = map.get("haiwaiext_6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_7")) {
      Object obj = map.get("haiwaiext_7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_8")) {
      Object obj = map.get("haiwaiext_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_9")) {
      Object obj = map.get("haiwaiext_9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_10")) {
      Object obj = map.get("haiwaiext_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount_10")) {
      Object obj = map.get("tax_amount_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmount10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax_10")) {
      Object obj = map.get("amount_without_tax_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithoutTax10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax_10")) {
      Object obj = map.get("amount_with_tax_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTax10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount_8")) {
      Object obj = map.get("tax_amount_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmount8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax_8")) {
      Object obj = map.get("amount_without_tax_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithoutTax8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax_8")) {
      Object obj = map.get("amount_with_tax_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTax8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiage_method")) {
      Object obj = map.get("jiage_method");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiageMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("subtype")) {
      Object obj = map.get("subtype");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubtype((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("document_date")) {
      Object obj = map.get("document_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expense_category")) {
      Object obj = map.get("expense_category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotalAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_net_amount_excluding_taxes")) {
      Object obj = map.get("total_net_amount_excluding_taxes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotalNetAmountExcludingTaxes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total_tax")) {
      Object obj = map.get("total_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotalTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplier_name")) {
      Object obj = map.get("supplier_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_type")) {
      Object obj = map.get("customer_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplier_address")) {
      Object obj = map.get("supplier_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplier_country")) {
      Object obj = map.get("supplier_country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("document_number")) {
      Object obj = map.get("document_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payment_terms")) {
      Object obj = map.get("payment_terms");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentTerms((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reference_doc_number")) {
      Object obj = map.get("reference_doc_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReferenceDocNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate_total")) {
      Object obj = map.get("tax_rate_total");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRateTotal((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dueDate")) {
      Object obj = map.get("dueDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDueDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kaijuren_name")) {
      Object obj = map.get("kaijuren_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKaijurenName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kaijuren_job")) {
      Object obj = map.get("kaijuren_job");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKaijurenJob((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kaijurendengji_no")) {
      Object obj = map.get("kaijurendengji_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKaijurendengjiNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jieshouren_name")) {
      Object obj = map.get("jieshouren_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJieshourenName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jieshouren_job")) {
      Object obj = map.get("jieshouren_job");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJieshourenJob((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrFinish((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrDuration((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_1")) {
      Object obj = map.get("haiwaiext_1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_2")) {
      Object obj = map.get("haiwaiext_2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_3")) {
      Object obj = map.get("haiwaiext_3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_4")) {
      Object obj = map.get("haiwaiext_4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_5")) {
      Object obj = map.get("haiwaiext_5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_6")) {
      Object obj = map.get("haiwaiext_6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_7")) {
      Object obj = map.get("haiwaiext_7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_8")) {
      Object obj = map.get("haiwaiext_8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_9")) {
      Object obj = map.get("haiwaiext_9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_10")) {
      Object obj = map.get("haiwaiext_10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount_10")) {
      Object obj = map.get("tax_amount_10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAmount10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax_10")) {
      Object obj = map.get("amount_without_tax_10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithoutTax10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax_10")) {
      Object obj = map.get("amount_with_tax_10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithTax10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount_8")) {
      Object obj = map.get("tax_amount_8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAmount8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax_8")) {
      Object obj = map.get("amount_without_tax_8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithoutTax8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax_8")) {
      Object obj = map.get("amount_with_tax_8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithTax8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jiage_method")) {
      Object obj = map.get("jiage_method");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiageMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
