package com.xforceplus.imageservicesaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketHaiwaifapiaozhuxinxishuilvDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   *  税额
   */
  private BigDecimal taxAmountShuilv;

  /**
   * 含税金额
   */
  private BigDecimal amountWithTaxShuilv;

  /**
   *  税率
   */
  private BigDecimal taxRateShuilv;

  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTaxShuilv;

  /**
   * 扩展字段1
   */
  private String ext1Shuilv;

  /**
   * 扩展字段2
   */
  private String ext2Shuilv;

  /**
   * 扩展字段3
   */
  private String ext3Shuilv;

  /**
   * 扩展字段4
   */
  private String ext4Shuilv;

  /**
   * 扩展字段5
   */
  private String ext5Shuilv;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 识别率
   */
  private String ocrRate;

  /**
   * 识别完成时间
   */
  private String ocrFinish;

  /**
   * 识别耗时
   */
  private String ocrDuration;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tax_amount_shuilv", taxAmountShuilv);
      map.put("amount_with_tax_shuilv", amountWithTaxShuilv);
      map.put("tax_rate_shuilv", taxRateShuilv);
      map.put("amount_without_tax_shuilv", amountWithoutTaxShuilv);
      map.put("ext1_shuilv", ext1Shuilv);
      map.put("ext2_shuilv", ext2Shuilv);
      map.put("ext3_shuilv", ext3Shuilv);
      map.put("ext4_shuilv", ext4Shuilv);
      map.put("ext5_shuilv", ext5Shuilv);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ocr_rate", ocrRate);
      map.put("ocr_finish", ocrFinish);
      map.put("ocr_duration", ocrDuration);
      map.put("org_tree", orgTree);

      return map;
  }

  public static TicketHaiwaifapiaozhuxinxishuilvDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketHaiwaifapiaozhuxinxishuilvDetail entity = new TicketHaiwaifapiaozhuxinxishuilvDetail();
    if(map.containsKey("tax_amount_shuilv")) {
      Object obj = map.get("tax_amount_shuilv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmountShuilv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmountShuilv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmountShuilv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmountShuilv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmountShuilv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax_shuilv")) {
      Object obj = map.get("amount_with_tax_shuilv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTaxShuilv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTaxShuilv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTaxShuilv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTaxShuilv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTaxShuilv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate_shuilv")) {
      Object obj = map.get("tax_rate_shuilv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRateShuilv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRateShuilv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRateShuilv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRateShuilv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRateShuilv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax_shuilv")) {
      Object obj = map.get("amount_without_tax_shuilv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTaxShuilv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTaxShuilv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTaxShuilv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTaxShuilv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTaxShuilv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext1_shuilv")) {
      Object obj = map.get("ext1_shuilv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1Shuilv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2_shuilv")) {
      Object obj = map.get("ext2_shuilv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2Shuilv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3_shuilv")) {
      Object obj = map.get("ext3_shuilv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3Shuilv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4_shuilv")) {
      Object obj = map.get("ext4_shuilv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4Shuilv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5_shuilv")) {
      Object obj = map.get("ext5_shuilv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5Shuilv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrFinish((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrDuration((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("tax_amount_shuilv")) {
      Object obj = map.get("tax_amount_shuilv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmountShuilv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmountShuilv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmountShuilv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmountShuilv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmountShuilv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax_shuilv")) {
      Object obj = map.get("amount_with_tax_shuilv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTaxShuilv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTaxShuilv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTaxShuilv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTaxShuilv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTaxShuilv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate_shuilv")) {
      Object obj = map.get("tax_rate_shuilv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRateShuilv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRateShuilv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRateShuilv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRateShuilv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRateShuilv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax_shuilv")) {
      Object obj = map.get("amount_without_tax_shuilv");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTaxShuilv((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTaxShuilv(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTaxShuilv(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTaxShuilv(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTaxShuilv(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("ext1_shuilv")) {
      Object obj = map.get("ext1_shuilv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1Shuilv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2_shuilv")) {
      Object obj = map.get("ext2_shuilv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2Shuilv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3_shuilv")) {
      Object obj = map.get("ext3_shuilv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3Shuilv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4_shuilv")) {
      Object obj = map.get("ext4_shuilv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4Shuilv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5_shuilv")) {
      Object obj = map.get("ext5_shuilv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5Shuilv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrFinish((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrDuration((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
