package com.xforceplus.imageservicesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.imageservicesaas.entity.Ticket;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketJptingchefei extends Ticket {


  /**
   * 精算机号
   */
  private String jingsuanjiNo;

  /**
   * 登录番号
   */
  private String denglufanNoTcf;

  /**
   * 国家
   */
  private String country;

  /**
   * 付款人姓名
   */
  private String fukuanrenNameYj;

  /**
   * 收款人姓名
   */
  private String shoukuanrenNameYj;

  /**
   * 收款人账号
   */
  private String shoukuanrenzhangNoYj;

  /**
   * 付款原因
   */
  private String fukuanReasonYj;

  /**
   * 转账金额
   */
  private String zhuanzhangAmountYj;

  /**
   * 子类型
   */
  private String tingcheZileixing;

  /**
   * 入库时刻
   */
  private String rukuTime;

  /**
   * 出库时刻
   */
  private String chukuTime;

  /**
   * 付款日期
   */
  private String fukuanDateYj;

  /**
   * 驻车时间（小时）
   */
  private String zhucheTime;

  /**
   * 驻车料金
   */
  private String zhucheliaoAmount;

  /**
   * 识别率
   */
  private String ocrRate;

  /**
   * 识别完成时间
   */
  private String ocrFinish;

  /**
   * 识别耗时
   */
  private String ocrDuration;

  /**
   * 扩展字段1
   */
  private String haiwaiext1;

  /**
   * 扩展字段2
   */
  private String haiwaiext2;

  /**
   * 扩展字段3
   */
  private String haiwaiext3;

  /**
   * 扩展字段4
   */
  private String haiwaiext4;

  /**
   * 扩展字段5
   */
  private String haiwaiext5;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("jingsuanji_no", jingsuanjiNo);
      map.put("denglufan_no_tcf", denglufanNoTcf);
      map.put("country", country);
      map.put("fukuanren_name_yj", fukuanrenNameYj);
      map.put("shoukuanren_name_yj", shoukuanrenNameYj);
      map.put("shoukuanrenzhang_no_yj", shoukuanrenzhangNoYj);
      map.put("fukuan_reason_yj", fukuanReasonYj);
      map.put("zhuanzhang_amount_yj", zhuanzhangAmountYj);
      map.put("tingche_zileixing", tingcheZileixing);
      map.put("ruku_time", rukuTime);
      map.put("chuku_time", chukuTime);
      map.put("fukuan_date_yj", fukuanDateYj);
      map.put("zhuche_time", zhucheTime);
      map.put("zhucheliao_amount", zhucheliaoAmount);
      map.put("ocr_rate", ocrRate);
      map.put("ocr_finish", ocrFinish);
      map.put("ocr_duration", ocrDuration);
      map.put("haiwaiext_1", haiwaiext1);
      map.put("haiwaiext_2", haiwaiext2);
      map.put("haiwaiext_3", haiwaiext3);
      map.put("haiwaiext_4", haiwaiext4);
      map.put("haiwaiext_5", haiwaiext5);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static TicketJptingchefei fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketJptingchefei entity = new TicketJptingchefei();
    entity.setParentByOQSMap(map);
    if(map.containsKey("jingsuanji_no")) {
      Object obj = map.get("jingsuanji_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJingsuanjiNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("denglufan_no_tcf")) {
      Object obj = map.get("denglufan_no_tcf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDenglufanNoTcf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fukuanren_name_yj")) {
      Object obj = map.get("fukuanren_name_yj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFukuanrenNameYj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shoukuanren_name_yj")) {
      Object obj = map.get("shoukuanren_name_yj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShoukuanrenNameYj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shoukuanrenzhang_no_yj")) {
      Object obj = map.get("shoukuanrenzhang_no_yj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShoukuanrenzhangNoYj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fukuan_reason_yj")) {
      Object obj = map.get("fukuan_reason_yj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFukuanReasonYj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhuanzhang_amount_yj")) {
      Object obj = map.get("zhuanzhang_amount_yj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhuanzhangAmountYj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tingche_zileixing")) {
      Object obj = map.get("tingche_zileixing");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTingcheZileixing((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ruku_time")) {
      Object obj = map.get("ruku_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRukuTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chuku_time")) {
      Object obj = map.get("chuku_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChukuTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fukuan_date_yj")) {
      Object obj = map.get("fukuan_date_yj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFukuanDateYj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhuche_time")) {
      Object obj = map.get("zhuche_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhucheTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhucheliao_amount")) {
      Object obj = map.get("zhucheliao_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhucheliaoAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrFinish((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrDuration((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_1")) {
      Object obj = map.get("haiwaiext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_2")) {
      Object obj = map.get("haiwaiext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_3")) {
      Object obj = map.get("haiwaiext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_4")) {
      Object obj = map.get("haiwaiext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_5")) {
      Object obj = map.get("haiwaiext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("jingsuanji_no")) {
      Object obj = map.get("jingsuanji_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJingsuanjiNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("denglufan_no_tcf")) {
      Object obj = map.get("denglufan_no_tcf");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDenglufanNoTcf((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fukuanren_name_yj")) {
      Object obj = map.get("fukuanren_name_yj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFukuanrenNameYj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shoukuanren_name_yj")) {
      Object obj = map.get("shoukuanren_name_yj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShoukuanrenNameYj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shoukuanrenzhang_no_yj")) {
      Object obj = map.get("shoukuanrenzhang_no_yj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShoukuanrenzhangNoYj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fukuan_reason_yj")) {
      Object obj = map.get("fukuan_reason_yj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFukuanReasonYj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhuanzhang_amount_yj")) {
      Object obj = map.get("zhuanzhang_amount_yj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhuanzhangAmountYj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tingche_zileixing")) {
      Object obj = map.get("tingche_zileixing");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTingcheZileixing((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ruku_time")) {
      Object obj = map.get("ruku_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRukuTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chuku_time")) {
      Object obj = map.get("chuku_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChukuTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fukuan_date_yj")) {
      Object obj = map.get("fukuan_date_yj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFukuanDateYj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhuche_time")) {
      Object obj = map.get("zhuche_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhucheTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhucheliao_amount")) {
      Object obj = map.get("zhucheliao_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhucheliaoAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrFinish((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrDuration((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_1")) {
      Object obj = map.get("haiwaiext_1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_2")) {
      Object obj = map.get("haiwaiext_2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_3")) {
      Object obj = map.get("haiwaiext_3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_4")) {
      Object obj = map.get("haiwaiext_4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_5")) {
      Object obj = map.get("haiwaiext_5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
