package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CheckUserConfig;
import com.xforceplus.imageservicesaas.service.ICheckUserConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class CheckUserConfigController {

  @Autowired
  private ICheckUserConfigService checkUserConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param checkUserConfig ${table.comment}
   * @return
   */
  @GetMapping("/checkuserconfigs" )
  public XfR getCheckUserConfigs(XfPage page, CheckUserConfig checkUserConfig) {
    return XfR.ok(checkUserConfigServiceImpl.page(page, Wrappers.query(checkUserConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/checkuserconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(checkUserConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param checkUserConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/checkuserconfigs")
  public XfR save(@RequestBody CheckUserConfig checkUserConfig) {
     return XfR.ok(checkUserConfigServiceImpl.save(checkUserConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param checkUserConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/checkuserconfigs/{id}")
  public XfR putUpdate(@RequestBody CheckUserConfig checkUserConfig,@PathVariable Long id) {
      checkUserConfig.setId(id);
      return XfR.ok(checkUserConfigServiceImpl.updateById(checkUserConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param checkUserConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/checkuserconfigs/{id}")
  public XfR patchUpdate(@RequestBody CheckUserConfig checkUserConfig,@PathVariable Long id) {
      CheckUserConfig upcheckUserConfig = checkUserConfigServiceImpl.getById(id);
      if(upcheckUserConfig != null){
        upcheckUserConfig = ObjectCopyUtils.copyProperties(checkUserConfig,upcheckUserConfig,true);
      }
      return XfR.ok(checkUserConfigServiceImpl.updateById(upcheckUserConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/checkuserconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(checkUserConfigServiceImpl.removeById(id));
  }

  @PostMapping("/checkuserconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "check_user_config");
     params.put("request", condition);

     return XfR.ok(checkUserConfigServiceImpl.querys(params));
  }

}
