package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareTicketImportDetail;
import com.xforceplus.imageservicesaas.service.ICompareTicketImportDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 比对进口发票明细前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class CompareTicketImportDetailController {

  @Autowired
  private ICompareTicketImportDetailService compareTicketImportDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketImportDetail 比对进口发票明细
   * @return
   */
  @GetMapping("/compareticketimportdetails" )
  public XfR getCompareTicketImportDetails(XfPage page, CompareTicketImportDetail compareTicketImportDetail) {
    return XfR.ok(compareTicketImportDetailServiceImpl.page(page, Wrappers.query(compareTicketImportDetail)));
  }

  /**
   * 通过id查询比对进口发票明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketimportdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketImportDetailServiceImpl.getById(id));
  }

  /**
   * 新增比对进口发票明细
   * @param compareTicketImportDetail 比对进口发票明细
   * @return XfR
   */
  @PostMapping("/compareticketimportdetails")
  public XfR save(@RequestBody CompareTicketImportDetail compareTicketImportDetail) {
     return XfR.ok(compareTicketImportDetailServiceImpl.save(compareTicketImportDetail));
  }

  /**
   * 修改-传入修改后的全部数据比对进口发票明细
   * @param compareTicketImportDetail 比对进口发票明细
   * @return XfR
   */
  @PutMapping("/compareticketimportdetails/{id}")
  public XfR putUpdate(@RequestBody CompareTicketImportDetail compareTicketImportDetail,@PathVariable Long id) {
      compareTicketImportDetail.setId(id);
      return XfR.ok(compareTicketImportDetailServiceImpl.updateById(compareTicketImportDetail));
  }

  /**
   * 修改-传入修改的数据比对进口发票明细
   * @param compareTicketImportDetail 比对进口发票明细
   * @return XfR
   */
  @PatchMapping("/compareticketimportdetails/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketImportDetail compareTicketImportDetail,@PathVariable Long id) {
      CompareTicketImportDetail upcompareTicketImportDetail = compareTicketImportDetailServiceImpl.getById(id);
      if(upcompareTicketImportDetail != null){
        upcompareTicketImportDetail = ObjectCopyUtils.copyProperties(compareTicketImportDetail,upcompareTicketImportDetail,true);
      }
      return XfR.ok(compareTicketImportDetailServiceImpl.updateById(upcompareTicketImportDetail));
  }

  /**
   * 通过id删除比对进口发票明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketimportdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketImportDetailServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketimportdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_import_detail");
     params.put("request", condition);

     return XfR.ok(compareTicketImportDetailServiceImpl.querys(params));
  }

}
