package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareTicketMany;
import com.xforceplus.imageservicesaas.service.ICompareTicketManyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 数据比对用途的多票前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class CompareTicketManyController {

  @Autowired
  private ICompareTicketManyService compareTicketManyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketMany 数据比对用途的多票
   * @return
   */
  @GetMapping("/compareticketmanys" )
  public XfR getCompareTicketManys(XfPage page, CompareTicketMany compareTicketMany) {
    return XfR.ok(compareTicketManyServiceImpl.page(page, Wrappers.query(compareTicketMany)));
  }

  /**
   * 通过id查询数据比对用途的多票
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketmanys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketManyServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的多票
   * @param compareTicketMany 数据比对用途的多票
   * @return XfR
   */
  @PostMapping("/compareticketmanys")
  public XfR save(@RequestBody CompareTicketMany compareTicketMany) {
     return XfR.ok(compareTicketManyServiceImpl.save(compareTicketMany));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的多票
   * @param compareTicketMany 数据比对用途的多票
   * @return XfR
   */
  @PutMapping("/compareticketmanys/{id}")
  public XfR putUpdate(@RequestBody CompareTicketMany compareTicketMany,@PathVariable Long id) {
      compareTicketMany.setId(id);
      return XfR.ok(compareTicketManyServiceImpl.updateById(compareTicketMany));
  }

  /**
   * 修改-传入修改的数据数据比对用途的多票
   * @param compareTicketMany 数据比对用途的多票
   * @return XfR
   */
  @PatchMapping("/compareticketmanys/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketMany compareTicketMany,@PathVariable Long id) {
      CompareTicketMany upcompareTicketMany = compareTicketManyServiceImpl.getById(id);
      if(upcompareTicketMany != null){
        upcompareTicketMany = ObjectCopyUtils.copyProperties(compareTicketMany,upcompareTicketMany,true);
      }
      return XfR.ok(compareTicketManyServiceImpl.updateById(upcompareTicketMany));
  }

  /**
   * 通过id删除数据比对用途的多票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketmanys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketManyServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketmanys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_many");
     params.put("request", condition);

     return XfR.ok(compareTicketManyServiceImpl.querys(params));
  }

}
