package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.Dummy;
import com.xforceplus.imageservicesaas.service.IDummyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 测试前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class DummyController {

  @Autowired
  private IDummyService dummyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dummy 测试
   * @return
   */
  @GetMapping("/dummys" )
  public XfR getDummys(XfPage page, Dummy dummy) {
    return XfR.ok(dummyServiceImpl.page(page, Wrappers.query(dummy)));
  }

  /**
   * 通过id查询测试
   * @param  id
   * @return XfR
   */
  @GetMapping("/dummys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dummyServiceImpl.getById(id));
  }

  /**
   * 新增测试
   * @param dummy 测试
   * @return XfR
   */
  @PostMapping("/dummys")
  public XfR save(@RequestBody Dummy dummy) {
     return XfR.ok(dummyServiceImpl.save(dummy));
  }

  /**
   * 修改-传入修改后的全部数据测试
   * @param dummy 测试
   * @return XfR
   */
  @PutMapping("/dummys/{id}")
  public XfR putUpdate(@RequestBody Dummy dummy,@PathVariable Long id) {
      dummy.setId(id);
      return XfR.ok(dummyServiceImpl.updateById(dummy));
  }

  /**
   * 修改-传入修改的数据测试
   * @param dummy 测试
   * @return XfR
   */
  @PatchMapping("/dummys/{id}")
  public XfR patchUpdate(@RequestBody Dummy dummy,@PathVariable Long id) {
      Dummy updummy = dummyServiceImpl.getById(id);
      if(updummy != null){
        updummy = ObjectCopyUtils.copyProperties(dummy,updummy,true);
      }
      return XfR.ok(dummyServiceImpl.updateById(updummy));
  }

  /**
   * 通过id删除测试
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dummys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dummyServiceImpl.removeById(id));
  }

  @PostMapping("/dummys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dummy");
     params.put("request", condition);

     return XfR.ok(dummyServiceImpl.querys(params));
  }

}
