package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.ImageIndex;
import com.xforceplus.imageservicesaas.service.IImageIndexService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 影像关系表前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class ImageIndexController {

  @Autowired
  private IImageIndexService imageIndexServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param imageIndex 影像关系表
   * @return
   */
  @GetMapping("/imageindexs" )
  public XfR getImageIndexs(XfPage page, ImageIndex imageIndex) {
    return XfR.ok(imageIndexServiceImpl.page(page, Wrappers.query(imageIndex)));
  }

  /**
   * 通过id查询影像关系表
   * @param  id
   * @return XfR
   */
  @GetMapping("/imageindexs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(imageIndexServiceImpl.getById(id));
  }

  /**
   * 新增影像关系表
   * @param imageIndex 影像关系表
   * @return XfR
   */
  @PostMapping("/imageindexs")
  public XfR save(@RequestBody ImageIndex imageIndex) {
     return XfR.ok(imageIndexServiceImpl.save(imageIndex));
  }

  /**
   * 修改-传入修改后的全部数据影像关系表
   * @param imageIndex 影像关系表
   * @return XfR
   */
  @PutMapping("/imageindexs/{id}")
  public XfR putUpdate(@RequestBody ImageIndex imageIndex,@PathVariable Long id) {
      imageIndex.setId(id);
      return XfR.ok(imageIndexServiceImpl.updateById(imageIndex));
  }

  /**
   * 修改-传入修改的数据影像关系表
   * @param imageIndex 影像关系表
   * @return XfR
   */
  @PatchMapping("/imageindexs/{id}")
  public XfR patchUpdate(@RequestBody ImageIndex imageIndex,@PathVariable Long id) {
      ImageIndex upimageIndex = imageIndexServiceImpl.getById(id);
      if(upimageIndex != null){
        upimageIndex = ObjectCopyUtils.copyProperties(imageIndex,upimageIndex,true);
      }
      return XfR.ok(imageIndexServiceImpl.updateById(upimageIndex));
  }

  /**
   * 通过id删除影像关系表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/imageindexs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(imageIndexServiceImpl.removeById(id));
  }

  @PostMapping("/imageindexs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "image_index");
     params.put("request", condition);

     return XfR.ok(imageIndexServiceImpl.querys(params));
  }

}
