package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TaskHistory;
import com.xforceplus.imageservicesaas.service.ITaskHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 任务历史记录前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class TaskHistoryController {

  @Autowired
  private ITaskHistoryService taskHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taskHistory 任务历史记录
   * @return
   */
  @GetMapping("/taskhistorys" )
  public XfR getTaskHistorys(XfPage page, TaskHistory taskHistory) {
    return XfR.ok(taskHistoryServiceImpl.page(page, Wrappers.query(taskHistory)));
  }

  /**
   * 通过id查询任务历史记录
   * @param  id
   * @return XfR
   */
  @GetMapping("/taskhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taskHistoryServiceImpl.getById(id));
  }

  /**
   * 新增任务历史记录
   * @param taskHistory 任务历史记录
   * @return XfR
   */
  @PostMapping("/taskhistorys")
  public XfR save(@RequestBody TaskHistory taskHistory) {
     return XfR.ok(taskHistoryServiceImpl.save(taskHistory));
  }

  /**
   * 修改-传入修改后的全部数据任务历史记录
   * @param taskHistory 任务历史记录
   * @return XfR
   */
  @PutMapping("/taskhistorys/{id}")
  public XfR putUpdate(@RequestBody TaskHistory taskHistory,@PathVariable Long id) {
      taskHistory.setId(id);
      return XfR.ok(taskHistoryServiceImpl.updateById(taskHistory));
  }

  /**
   * 修改-传入修改的数据任务历史记录
   * @param taskHistory 任务历史记录
   * @return XfR
   */
  @PatchMapping("/taskhistorys/{id}")
  public XfR patchUpdate(@RequestBody TaskHistory taskHistory,@PathVariable Long id) {
      TaskHistory uptaskHistory = taskHistoryServiceImpl.getById(id);
      if(uptaskHistory != null){
        uptaskHistory = ObjectCopyUtils.copyProperties(taskHistory,uptaskHistory,true);
      }
      return XfR.ok(taskHistoryServiceImpl.updateById(uptaskHistory));
  }

  /**
   * 通过id删除任务历史记录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taskhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taskHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/taskhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "task_history");
     params.put("request", condition);

     return XfR.ok(taskHistoryServiceImpl.querys(params));
  }

}
