package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketMedicalDetail;
import com.xforceplus.imageservicesaas.service.ITicketMedicalDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class TicketMedicalDetailController {

  @Autowired
  private ITicketMedicalDetailService ticketMedicalDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketMedicalDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketmedicaldetails" )
  public XfR getTicketMedicalDetails(XfPage page, TicketMedicalDetail ticketMedicalDetail) {
    return XfR.ok(ticketMedicalDetailServiceImpl.page(page, Wrappers.query(ticketMedicalDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketmedicaldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketMedicalDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketMedicalDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketmedicaldetails")
  public XfR save(@RequestBody TicketMedicalDetail ticketMedicalDetail) {
     return XfR.ok(ticketMedicalDetailServiceImpl.save(ticketMedicalDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketMedicalDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketmedicaldetails/{id}")
  public XfR putUpdate(@RequestBody TicketMedicalDetail ticketMedicalDetail,@PathVariable Long id) {
      ticketMedicalDetail.setId(id);
      return XfR.ok(ticketMedicalDetailServiceImpl.updateById(ticketMedicalDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketMedicalDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketmedicaldetails/{id}")
  public XfR patchUpdate(@RequestBody TicketMedicalDetail ticketMedicalDetail,@PathVariable Long id) {
      TicketMedicalDetail upticketMedicalDetail = ticketMedicalDetailServiceImpl.getById(id);
      if(upticketMedicalDetail != null){
        upticketMedicalDetail = ObjectCopyUtils.copyProperties(ticketMedicalDetail,upticketMedicalDetail,true);
      }
      return XfR.ok(ticketMedicalDetailServiceImpl.updateById(upticketMedicalDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketmedicaldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketMedicalDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketmedicaldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_medical_detail");
     params.put("request", condition);

     return XfR.ok(ticketMedicalDetailServiceImpl.querys(params));
  }

}
