package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketOCRTaxi;
import com.xforceplus.imageservicesaas.service.ITicketOCRTaxiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class TicketOCRTaxiController {

  @Autowired
  private ITicketOCRTaxiService ticketOCRTaxiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketOCRTaxi ${table.comment}
   * @return
   */
  @GetMapping("/ticketocrtaxis" )
  public XfR getTicketOCRTaxis(XfPage page, TicketOCRTaxi ticketOCRTaxi) {
    return XfR.ok(ticketOCRTaxiServiceImpl.page(page, Wrappers.query(ticketOCRTaxi)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketocrtaxis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketOCRTaxiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketOCRTaxi ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketocrtaxis")
  public XfR save(@RequestBody TicketOCRTaxi ticketOCRTaxi) {
     return XfR.ok(ticketOCRTaxiServiceImpl.save(ticketOCRTaxi));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketOCRTaxi ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketocrtaxis/{id}")
  public XfR putUpdate(@RequestBody TicketOCRTaxi ticketOCRTaxi,@PathVariable Long id) {
      ticketOCRTaxi.setId(id);
      return XfR.ok(ticketOCRTaxiServiceImpl.updateById(ticketOCRTaxi));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketOCRTaxi ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketocrtaxis/{id}")
  public XfR patchUpdate(@RequestBody TicketOCRTaxi ticketOCRTaxi,@PathVariable Long id) {
      TicketOCRTaxi upticketOCRTaxi = ticketOCRTaxiServiceImpl.getById(id);
      if(upticketOCRTaxi != null){
        upticketOCRTaxi = ObjectCopyUtils.copyProperties(ticketOCRTaxi,upticketOCRTaxi,true);
      }
      return XfR.ok(ticketOCRTaxiServiceImpl.updateById(upticketOCRTaxi));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketocrtaxis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketOCRTaxiServiceImpl.removeById(id));
  }

  @PostMapping("/ticketocrtaxis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_o_c_r_taxi");
     params.put("request", condition);

     return XfR.ok(ticketOCRTaxiServiceImpl.querys(params));
  }

}
