package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketRelation;
import com.xforceplus.imageservicesaas.service.ITicketRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-10
 */
@RestController
public class TicketRelationController {

  @Autowired
  private ITicketRelationService ticketRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketRelation ${table.comment}
   * @return
   */
  @GetMapping("/ticketrelations" )
  public XfR getTicketRelations(XfPage page, TicketRelation ticketRelation) {
    return XfR.ok(ticketRelationServiceImpl.page(page, Wrappers.query(ticketRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketrelations")
  public XfR save(@RequestBody TicketRelation ticketRelation) {
     return XfR.ok(ticketRelationServiceImpl.save(ticketRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketrelations/{id}")
  public XfR putUpdate(@RequestBody TicketRelation ticketRelation,@PathVariable Long id) {
      ticketRelation.setId(id);
      return XfR.ok(ticketRelationServiceImpl.updateById(ticketRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketrelations/{id}")
  public XfR patchUpdate(@RequestBody TicketRelation ticketRelation,@PathVariable Long id) {
      TicketRelation upticketRelation = ticketRelationServiceImpl.getById(id);
      if(upticketRelation != null){
        upticketRelation = ObjectCopyUtils.copyProperties(ticketRelation,upticketRelation,true);
      }
      return XfR.ok(ticketRelationServiceImpl.updateById(upticketRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketRelationServiceImpl.removeById(id));
  }

  @PostMapping("/ticketrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_relation");
     params.put("request", condition);

     return XfR.ok(ticketRelationServiceImpl.querys(params));
  }

}
