package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.ApiErrorCode;
import com.xforceplus.imageservicesaas.service.IApiErrorCodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class ApiErrorCodeController {

  @Autowired
  private IApiErrorCodeService apiErrorCodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param apiErrorCode ${table.comment}
   * @return
   */
  @GetMapping("/apierrorcodes" )
  public XfR getApiErrorCodes(XfPage page, ApiErrorCode apiErrorCode) {
    return XfR.ok(apiErrorCodeServiceImpl.page(page, Wrappers.query(apiErrorCode)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/apierrorcodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(apiErrorCodeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param apiErrorCode ${table.comment}
   * @return XfR
   */
  @PostMapping("/apierrorcodes")
  public XfR save(@RequestBody ApiErrorCode apiErrorCode) {
     return XfR.ok(apiErrorCodeServiceImpl.save(apiErrorCode));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param apiErrorCode ${table.comment}
   * @return XfR
   */
  @PutMapping("/apierrorcodes/{id}")
  public XfR putUpdate(@RequestBody ApiErrorCode apiErrorCode,@PathVariable Long id) {
      apiErrorCode.setId(id);
      return XfR.ok(apiErrorCodeServiceImpl.updateById(apiErrorCode));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param apiErrorCode ${table.comment}
   * @return XfR
   */
  @PatchMapping("/apierrorcodes/{id}")
  public XfR patchUpdate(@RequestBody ApiErrorCode apiErrorCode,@PathVariable Long id) {
      ApiErrorCode upapiErrorCode = apiErrorCodeServiceImpl.getById(id);
      if(upapiErrorCode != null){
        upapiErrorCode = ObjectCopyUtils.copyProperties(apiErrorCode,upapiErrorCode,true);
      }
      return XfR.ok(apiErrorCodeServiceImpl.updateById(upapiErrorCode));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/apierrorcodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(apiErrorCodeServiceImpl.removeById(id));
  }

  @PostMapping("/apierrorcodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "api_error_code");
     params.put("request", condition);

     return XfR.ok(apiErrorCodeServiceImpl.querys(params));
  }

}
