package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.BatchUpdateTicket;
import com.xforceplus.imageservicesaas.service.IBatchUpdateTicketService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class BatchUpdateTicketController {

  @Autowired
  private IBatchUpdateTicketService batchUpdateTicketServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param batchUpdateTicket ${table.comment}
   * @return
   */
  @GetMapping("/batchupdatetickets" )
  public XfR getBatchUpdateTickets(XfPage page, BatchUpdateTicket batchUpdateTicket) {
    return XfR.ok(batchUpdateTicketServiceImpl.page(page, Wrappers.query(batchUpdateTicket)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/batchupdatetickets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(batchUpdateTicketServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param batchUpdateTicket ${table.comment}
   * @return XfR
   */
  @PostMapping("/batchupdatetickets")
  public XfR save(@RequestBody BatchUpdateTicket batchUpdateTicket) {
     return XfR.ok(batchUpdateTicketServiceImpl.save(batchUpdateTicket));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param batchUpdateTicket ${table.comment}
   * @return XfR
   */
  @PutMapping("/batchupdatetickets/{id}")
  public XfR putUpdate(@RequestBody BatchUpdateTicket batchUpdateTicket,@PathVariable Long id) {
      batchUpdateTicket.setId(id);
      return XfR.ok(batchUpdateTicketServiceImpl.updateById(batchUpdateTicket));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param batchUpdateTicket ${table.comment}
   * @return XfR
   */
  @PatchMapping("/batchupdatetickets/{id}")
  public XfR patchUpdate(@RequestBody BatchUpdateTicket batchUpdateTicket,@PathVariable Long id) {
      BatchUpdateTicket upbatchUpdateTicket = batchUpdateTicketServiceImpl.getById(id);
      if(upbatchUpdateTicket != null){
        upbatchUpdateTicket = ObjectCopyUtils.copyProperties(batchUpdateTicket,upbatchUpdateTicket,true);
      }
      return XfR.ok(batchUpdateTicketServiceImpl.updateById(upbatchUpdateTicket));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/batchupdatetickets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(batchUpdateTicketServiceImpl.removeById(id));
  }

  @PostMapping("/batchupdatetickets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "batch_update_ticket");
     params.put("request", condition);

     return XfR.ok(batchUpdateTicketServiceImpl.querys(params));
  }

}
