package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CheckSystemConfig;
import com.xforceplus.imageservicesaas.service.ICheckSystemConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class CheckSystemConfigController {

  @Autowired
  private ICheckSystemConfigService checkSystemConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param checkSystemConfig ${table.comment}
   * @return
   */
  @GetMapping("/checksystemconfigs" )
  public XfR getCheckSystemConfigs(XfPage page, CheckSystemConfig checkSystemConfig) {
    return XfR.ok(checkSystemConfigServiceImpl.page(page, Wrappers.query(checkSystemConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/checksystemconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(checkSystemConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param checkSystemConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/checksystemconfigs")
  public XfR save(@RequestBody CheckSystemConfig checkSystemConfig) {
     return XfR.ok(checkSystemConfigServiceImpl.save(checkSystemConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param checkSystemConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/checksystemconfigs/{id}")
  public XfR putUpdate(@RequestBody CheckSystemConfig checkSystemConfig,@PathVariable Long id) {
      checkSystemConfig.setId(id);
      return XfR.ok(checkSystemConfigServiceImpl.updateById(checkSystemConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param checkSystemConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/checksystemconfigs/{id}")
  public XfR patchUpdate(@RequestBody CheckSystemConfig checkSystemConfig,@PathVariable Long id) {
      CheckSystemConfig upcheckSystemConfig = checkSystemConfigServiceImpl.getById(id);
      if(upcheckSystemConfig != null){
        upcheckSystemConfig = ObjectCopyUtils.copyProperties(checkSystemConfig,upcheckSystemConfig,true);
      }
      return XfR.ok(checkSystemConfigServiceImpl.updateById(upcheckSystemConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/checksystemconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(checkSystemConfigServiceImpl.removeById(id));
  }

  @PostMapping("/checksystemconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "check_system_config");
     params.put("request", condition);

     return XfR.ok(checkSystemConfigServiceImpl.querys(params));
  }

}
