package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareExpensesBill;
import com.xforceplus.imageservicesaas.service.ICompareExpensesBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 数据比对用途的 费用报销费用单前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class CompareExpensesBillController {

  @Autowired
  private ICompareExpensesBillService compareExpensesBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareExpensesBill 数据比对用途的 费用报销费用单
   * @return
   */
  @GetMapping("/compareexpensesbills" )
  public XfR getCompareExpensesBills(XfPage page, CompareExpensesBill compareExpensesBill) {
    return XfR.ok(compareExpensesBillServiceImpl.page(page, Wrappers.query(compareExpensesBill)));
  }

  /**
   * 通过id查询数据比对用途的 费用报销费用单
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareexpensesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareExpensesBillServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的 费用报销费用单
   * @param compareExpensesBill 数据比对用途的 费用报销费用单
   * @return XfR
   */
  @PostMapping("/compareexpensesbills")
  public XfR save(@RequestBody CompareExpensesBill compareExpensesBill) {
     return XfR.ok(compareExpensesBillServiceImpl.save(compareExpensesBill));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的 费用报销费用单
   * @param compareExpensesBill 数据比对用途的 费用报销费用单
   * @return XfR
   */
  @PutMapping("/compareexpensesbills/{id}")
  public XfR putUpdate(@RequestBody CompareExpensesBill compareExpensesBill,@PathVariable Long id) {
      compareExpensesBill.setId(id);
      return XfR.ok(compareExpensesBillServiceImpl.updateById(compareExpensesBill));
  }

  /**
   * 修改-传入修改的数据数据比对用途的 费用报销费用单
   * @param compareExpensesBill 数据比对用途的 费用报销费用单
   * @return XfR
   */
  @PatchMapping("/compareexpensesbills/{id}")
  public XfR patchUpdate(@RequestBody CompareExpensesBill compareExpensesBill,@PathVariable Long id) {
      CompareExpensesBill upcompareExpensesBill = compareExpensesBillServiceImpl.getById(id);
      if(upcompareExpensesBill != null){
        upcompareExpensesBill = ObjectCopyUtils.copyProperties(compareExpensesBill,upcompareExpensesBill,true);
      }
      return XfR.ok(compareExpensesBillServiceImpl.updateById(upcompareExpensesBill));
  }

  /**
   * 通过id删除数据比对用途的 费用报销费用单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareexpensesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareExpensesBillServiceImpl.removeById(id));
  }

  @PostMapping("/compareexpensesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_expenses_bill");
     params.put("request", condition);

     return XfR.ok(compareExpensesBillServiceImpl.querys(params));
  }

}
