package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.CompareTicketFinanceDetail;
import com.xforceplus.imageservicesaas.service.ICompareTicketFinanceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 比对财政票据明细前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class CompareTicketFinanceDetailController {

  @Autowired
  private ICompareTicketFinanceDetailService compareTicketFinanceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketFinanceDetail 比对财政票据明细
   * @return
   */
  @GetMapping("/compareticketfinancedetails" )
  public XfR getCompareTicketFinanceDetails(XfPage page, CompareTicketFinanceDetail compareTicketFinanceDetail) {
    return XfR.ok(compareTicketFinanceDetailServiceImpl.page(page, Wrappers.query(compareTicketFinanceDetail)));
  }

  /**
   * 通过id查询比对财政票据明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketfinancedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketFinanceDetailServiceImpl.getById(id));
  }

  /**
   * 新增比对财政票据明细
   * @param compareTicketFinanceDetail 比对财政票据明细
   * @return XfR
   */
  @PostMapping("/compareticketfinancedetails")
  public XfR save(@RequestBody CompareTicketFinanceDetail compareTicketFinanceDetail) {
     return XfR.ok(compareTicketFinanceDetailServiceImpl.save(compareTicketFinanceDetail));
  }

  /**
   * 修改-传入修改后的全部数据比对财政票据明细
   * @param compareTicketFinanceDetail 比对财政票据明细
   * @return XfR
   */
  @PutMapping("/compareticketfinancedetails/{id}")
  public XfR putUpdate(@RequestBody CompareTicketFinanceDetail compareTicketFinanceDetail,@PathVariable Long id) {
      compareTicketFinanceDetail.setId(id);
      return XfR.ok(compareTicketFinanceDetailServiceImpl.updateById(compareTicketFinanceDetail));
  }

  /**
   * 修改-传入修改的数据比对财政票据明细
   * @param compareTicketFinanceDetail 比对财政票据明细
   * @return XfR
   */
  @PatchMapping("/compareticketfinancedetails/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketFinanceDetail compareTicketFinanceDetail,@PathVariable Long id) {
      CompareTicketFinanceDetail upcompareTicketFinanceDetail = compareTicketFinanceDetailServiceImpl.getById(id);
      if(upcompareTicketFinanceDetail != null){
        upcompareTicketFinanceDetail = ObjectCopyUtils.copyProperties(compareTicketFinanceDetail,upcompareTicketFinanceDetail,true);
      }
      return XfR.ok(compareTicketFinanceDetailServiceImpl.updateById(upcompareTicketFinanceDetail));
  }

  /**
   * 通过id删除比对财政票据明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketfinancedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketFinanceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketfinancedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_finance_detail");
     params.put("request", condition);

     return XfR.ok(compareTicketFinanceDetailServiceImpl.querys(params));
  }

}
