package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.ConfigDictionary;
import com.xforceplus.imageservicesaas.service.IConfigDictionaryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class ConfigDictionaryController {

  @Autowired
  private IConfigDictionaryService configDictionaryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configDictionary ${table.comment}
   * @return
   */
  @GetMapping("/configdictionarys" )
  public XfR getConfigDictionarys(XfPage page, ConfigDictionary configDictionary) {
    return XfR.ok(configDictionaryServiceImpl.page(page, Wrappers.query(configDictionary)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configdictionarys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configDictionaryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configDictionary ${table.comment}
   * @return XfR
   */
  @PostMapping("/configdictionarys")
  public XfR save(@RequestBody ConfigDictionary configDictionary) {
     return XfR.ok(configDictionaryServiceImpl.save(configDictionary));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configDictionary ${table.comment}
   * @return XfR
   */
  @PutMapping("/configdictionarys/{id}")
  public XfR putUpdate(@RequestBody ConfigDictionary configDictionary,@PathVariable Long id) {
      configDictionary.setId(id);
      return XfR.ok(configDictionaryServiceImpl.updateById(configDictionary));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configDictionary ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configdictionarys/{id}")
  public XfR patchUpdate(@RequestBody ConfigDictionary configDictionary,@PathVariable Long id) {
      ConfigDictionary upconfigDictionary = configDictionaryServiceImpl.getById(id);
      if(upconfigDictionary != null){
        upconfigDictionary = ObjectCopyUtils.copyProperties(configDictionary,upconfigDictionary,true);
      }
      return XfR.ok(configDictionaryServiceImpl.updateById(upconfigDictionary));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configdictionarys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configDictionaryServiceImpl.removeById(id));
  }

  @PostMapping("/configdictionarys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_dictionary");
     params.put("request", condition);

     return XfR.ok(configDictionaryServiceImpl.querys(params));
  }

}
