package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketImport;
import com.xforceplus.imageservicesaas.service.ITicketImportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 进口类发票前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketImportController {

  @Autowired
  private ITicketImportService ticketImportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketImport 进口类发票
   * @return
   */
  @GetMapping("/ticketimports" )
  public XfR getTicketImports(XfPage page, TicketImport ticketImport) {
    return XfR.ok(ticketImportServiceImpl.page(page, Wrappers.query(ticketImport)));
  }

  /**
   * 通过id查询进口类发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketimports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketImportServiceImpl.getById(id));
  }

  /**
   * 新增进口类发票
   * @param ticketImport 进口类发票
   * @return XfR
   */
  @PostMapping("/ticketimports")
  public XfR save(@RequestBody TicketImport ticketImport) {
     return XfR.ok(ticketImportServiceImpl.save(ticketImport));
  }

  /**
   * 修改-传入修改后的全部数据进口类发票
   * @param ticketImport 进口类发票
   * @return XfR
   */
  @PutMapping("/ticketimports/{id}")
  public XfR putUpdate(@RequestBody TicketImport ticketImport,@PathVariable Long id) {
      ticketImport.setId(id);
      return XfR.ok(ticketImportServiceImpl.updateById(ticketImport));
  }

  /**
   * 修改-传入修改的数据进口类发票
   * @param ticketImport 进口类发票
   * @return XfR
   */
  @PatchMapping("/ticketimports/{id}")
  public XfR patchUpdate(@RequestBody TicketImport ticketImport,@PathVariable Long id) {
      TicketImport upticketImport = ticketImportServiceImpl.getById(id);
      if(upticketImport != null){
        upticketImport = ObjectCopyUtils.copyProperties(ticketImport,upticketImport,true);
      }
      return XfR.ok(ticketImportServiceImpl.updateById(upticketImport));
  }

  /**
   * 通过id删除进口类发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketimports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketImportServiceImpl.removeById(id));
  }

  @PostMapping("/ticketimports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_import");
     params.put("request", condition);

     return XfR.ok(ticketImportServiceImpl.querys(params));
  }

}
