package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketJpcanyin;
import com.xforceplus.imageservicesaas.service.ITicketJpcanyinService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJpcanyinController {

  @Autowired
  private ITicketJpcanyinService ticketJpcanyinServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJpcanyin ${table.comment}
   * @return
   */
  @GetMapping("/ticketjpcanyins" )
  public XfR getTicketJpcanyins(XfPage page, TicketJpcanyin ticketJpcanyin) {
    return XfR.ok(ticketJpcanyinServiceImpl.page(page, Wrappers.query(ticketJpcanyin)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjpcanyins/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJpcanyinServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJpcanyin ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjpcanyins")
  public XfR save(@RequestBody TicketJpcanyin ticketJpcanyin) {
     return XfR.ok(ticketJpcanyinServiceImpl.save(ticketJpcanyin));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJpcanyin ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjpcanyins/{id}")
  public XfR putUpdate(@RequestBody TicketJpcanyin ticketJpcanyin,@PathVariable Long id) {
      ticketJpcanyin.setId(id);
      return XfR.ok(ticketJpcanyinServiceImpl.updateById(ticketJpcanyin));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJpcanyin ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjpcanyins/{id}")
  public XfR patchUpdate(@RequestBody TicketJpcanyin ticketJpcanyin,@PathVariable Long id) {
      TicketJpcanyin upticketJpcanyin = ticketJpcanyinServiceImpl.getById(id);
      if(upticketJpcanyin != null){
        upticketJpcanyin = ObjectCopyUtils.copyProperties(ticketJpcanyin,upticketJpcanyin,true);
      }
      return XfR.ok(ticketJpcanyinServiceImpl.updateById(upticketJpcanyin));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjpcanyins/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJpcanyinServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjpcanyins/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jpcanyin");
     params.put("request", condition);

     return XfR.ok(ticketJpcanyinServiceImpl.querys(params));
  }

}
