package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketJpgouwu;
import com.xforceplus.imageservicesaas.service.ITicketJpgouwuService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJpgouwuController {

  @Autowired
  private ITicketJpgouwuService ticketJpgouwuServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJpgouwu ${table.comment}
   * @return
   */
  @GetMapping("/ticketjpgouwus" )
  public XfR getTicketJpgouwus(XfPage page, TicketJpgouwu ticketJpgouwu) {
    return XfR.ok(ticketJpgouwuServiceImpl.page(page, Wrappers.query(ticketJpgouwu)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjpgouwus/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJpgouwuServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJpgouwu ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjpgouwus")
  public XfR save(@RequestBody TicketJpgouwu ticketJpgouwu) {
     return XfR.ok(ticketJpgouwuServiceImpl.save(ticketJpgouwu));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJpgouwu ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjpgouwus/{id}")
  public XfR putUpdate(@RequestBody TicketJpgouwu ticketJpgouwu,@PathVariable Long id) {
      ticketJpgouwu.setId(id);
      return XfR.ok(ticketJpgouwuServiceImpl.updateById(ticketJpgouwu));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJpgouwu ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjpgouwus/{id}")
  public XfR patchUpdate(@RequestBody TicketJpgouwu ticketJpgouwu,@PathVariable Long id) {
      TicketJpgouwu upticketJpgouwu = ticketJpgouwuServiceImpl.getById(id);
      if(upticketJpgouwu != null){
        upticketJpgouwu = ObjectCopyUtils.copyProperties(ticketJpgouwu,upticketJpgouwu,true);
      }
      return XfR.ok(ticketJpgouwuServiceImpl.updateById(upticketJpgouwu));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjpgouwus/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJpgouwuServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjpgouwus/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jpgouwu");
     params.put("request", condition);

     return XfR.ok(ticketJpgouwuServiceImpl.querys(params));
  }

}
