package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketJpguolufei;
import com.xforceplus.imageservicesaas.service.ITicketJpguolufeiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJpguolufeiController {

  @Autowired
  private ITicketJpguolufeiService ticketJpguolufeiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJpguolufei ${table.comment}
   * @return
   */
  @GetMapping("/ticketjpguolufeis" )
  public XfR getTicketJpguolufeis(XfPage page, TicketJpguolufei ticketJpguolufei) {
    return XfR.ok(ticketJpguolufeiServiceImpl.page(page, Wrappers.query(ticketJpguolufei)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjpguolufeis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJpguolufeiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJpguolufei ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjpguolufeis")
  public XfR save(@RequestBody TicketJpguolufei ticketJpguolufei) {
     return XfR.ok(ticketJpguolufeiServiceImpl.save(ticketJpguolufei));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJpguolufei ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjpguolufeis/{id}")
  public XfR putUpdate(@RequestBody TicketJpguolufei ticketJpguolufei,@PathVariable Long id) {
      ticketJpguolufei.setId(id);
      return XfR.ok(ticketJpguolufeiServiceImpl.updateById(ticketJpguolufei));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJpguolufei ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjpguolufeis/{id}")
  public XfR patchUpdate(@RequestBody TicketJpguolufei ticketJpguolufei,@PathVariable Long id) {
      TicketJpguolufei upticketJpguolufei = ticketJpguolufeiServiceImpl.getById(id);
      if(upticketJpguolufei != null){
        upticketJpguolufei = ObjectCopyUtils.copyProperties(ticketJpguolufei,upticketJpguolufei,true);
      }
      return XfR.ok(ticketJpguolufeiServiceImpl.updateById(upticketJpguolufei));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjpguolufeis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJpguolufeiServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjpguolufeis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jpguolufei");
     params.put("request", condition);

     return XfR.ok(ticketJpguolufeiServiceImpl.querys(params));
  }

}
