package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketJpjiaotongfei;
import com.xforceplus.imageservicesaas.service.ITicketJpjiaotongfeiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJpjiaotongfeiController {

  @Autowired
  private ITicketJpjiaotongfeiService ticketJpjiaotongfeiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJpjiaotongfei ${table.comment}
   * @return
   */
  @GetMapping("/ticketjpjiaotongfeis" )
  public XfR getTicketJpjiaotongfeis(XfPage page, TicketJpjiaotongfei ticketJpjiaotongfei) {
    return XfR.ok(ticketJpjiaotongfeiServiceImpl.page(page, Wrappers.query(ticketJpjiaotongfei)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjpjiaotongfeis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJpjiaotongfeiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJpjiaotongfei ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjpjiaotongfeis")
  public XfR save(@RequestBody TicketJpjiaotongfei ticketJpjiaotongfei) {
     return XfR.ok(ticketJpjiaotongfeiServiceImpl.save(ticketJpjiaotongfei));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJpjiaotongfei ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjpjiaotongfeis/{id}")
  public XfR putUpdate(@RequestBody TicketJpjiaotongfei ticketJpjiaotongfei,@PathVariable Long id) {
      ticketJpjiaotongfei.setId(id);
      return XfR.ok(ticketJpjiaotongfeiServiceImpl.updateById(ticketJpjiaotongfei));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJpjiaotongfei ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjpjiaotongfeis/{id}")
  public XfR patchUpdate(@RequestBody TicketJpjiaotongfei ticketJpjiaotongfei,@PathVariable Long id) {
      TicketJpjiaotongfei upticketJpjiaotongfei = ticketJpjiaotongfeiServiceImpl.getById(id);
      if(upticketJpjiaotongfei != null){
        upticketJpjiaotongfei = ObjectCopyUtils.copyProperties(ticketJpjiaotongfei,upticketJpjiaotongfei,true);
      }
      return XfR.ok(ticketJpjiaotongfeiServiceImpl.updateById(upticketJpjiaotongfei));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjpjiaotongfeis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJpjiaotongfeiServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjpjiaotongfeis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jpjiaotongfei");
     params.put("request", condition);

     return XfR.ok(ticketJpjiaotongfeiServiceImpl.querys(params));
  }

}
