package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketJpjiudian;
import com.xforceplus.imageservicesaas.service.ITicketJpjiudianService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketJpjiudianController {

  @Autowired
  private ITicketJpjiudianService ticketJpjiudianServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketJpjiudian ${table.comment}
   * @return
   */
  @GetMapping("/ticketjpjiudians" )
  public XfR getTicketJpjiudians(XfPage page, TicketJpjiudian ticketJpjiudian) {
    return XfR.ok(ticketJpjiudianServiceImpl.page(page, Wrappers.query(ticketJpjiudian)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketjpjiudians/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketJpjiudianServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketJpjiudian ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketjpjiudians")
  public XfR save(@RequestBody TicketJpjiudian ticketJpjiudian) {
     return XfR.ok(ticketJpjiudianServiceImpl.save(ticketJpjiudian));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketJpjiudian ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketjpjiudians/{id}")
  public XfR putUpdate(@RequestBody TicketJpjiudian ticketJpjiudian,@PathVariable Long id) {
      ticketJpjiudian.setId(id);
      return XfR.ok(ticketJpjiudianServiceImpl.updateById(ticketJpjiudian));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketJpjiudian ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketjpjiudians/{id}")
  public XfR patchUpdate(@RequestBody TicketJpjiudian ticketJpjiudian,@PathVariable Long id) {
      TicketJpjiudian upticketJpjiudian = ticketJpjiudianServiceImpl.getById(id);
      if(upticketJpjiudian != null){
        upticketJpjiudian = ObjectCopyUtils.copyProperties(ticketJpjiudian,upticketJpjiudian,true);
      }
      return XfR.ok(ticketJpjiudianServiceImpl.updateById(upticketJpjiudian));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketjpjiudians/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketJpjiudianServiceImpl.removeById(id));
  }

  @PostMapping("/ticketjpjiudians/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_jpjiudian");
     params.put("request", condition);

     return XfR.ok(ticketJpjiudianServiceImpl.querys(params));
  }

}
