package com.xforceplus.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.imageservicesaas.entity.TicketPayment;
import com.xforceplus.imageservicesaas.service.ITicketPaymentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应付款前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class TicketPaymentController {

  @Autowired
  private ITicketPaymentService ticketPaymentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketPayment 应付款
   * @return
   */
  @GetMapping("/ticketpayments" )
  public XfR getTicketPayments(XfPage page, TicketPayment ticketPayment) {
    return XfR.ok(ticketPaymentServiceImpl.page(page, Wrappers.query(ticketPayment)));
  }

  /**
   * 通过id查询应付款
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketpayments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketPaymentServiceImpl.getById(id));
  }

  /**
   * 新增应付款
   * @param ticketPayment 应付款
   * @return XfR
   */
  @PostMapping("/ticketpayments")
  public XfR save(@RequestBody TicketPayment ticketPayment) {
     return XfR.ok(ticketPaymentServiceImpl.save(ticketPayment));
  }

  /**
   * 修改-传入修改后的全部数据应付款
   * @param ticketPayment 应付款
   * @return XfR
   */
  @PutMapping("/ticketpayments/{id}")
  public XfR putUpdate(@RequestBody TicketPayment ticketPayment,@PathVariable Long id) {
      ticketPayment.setId(id);
      return XfR.ok(ticketPaymentServiceImpl.updateById(ticketPayment));
  }

  /**
   * 修改-传入修改的数据应付款
   * @param ticketPayment 应付款
   * @return XfR
   */
  @PatchMapping("/ticketpayments/{id}")
  public XfR patchUpdate(@RequestBody TicketPayment ticketPayment,@PathVariable Long id) {
      TicketPayment upticketPayment = ticketPaymentServiceImpl.getById(id);
      if(upticketPayment != null){
        upticketPayment = ObjectCopyUtils.copyProperties(ticketPayment,upticketPayment,true);
      }
      return XfR.ok(ticketPaymentServiceImpl.updateById(upticketPayment));
  }

  /**
   * 通过id删除应付款
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketpayments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketPaymentServiceImpl.removeById(id));
  }

  @PostMapping("/ticketpayments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_payment");
     params.put("request", condition);

     return XfR.ok(ticketPaymentServiceImpl.querys(params));
  }

}
