/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.datalayer;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.xforceplus.janus.commons.datalayer.TableNameHandler;
import com.xforceplus.janus.commons.datalayer.TableNameParser;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.reflection.MetaObject;

public class DynamicTableNameParser
implements ISqlParser {
    private static TableNameHandler tableNameHandler = new TableNameHandler();

    public SqlInfo parser(MetaObject metaObject, String sql) {
        Collection<String> tables;
        if (this.allowProcess(metaObject) && CollectionUtils.isNotEmpty(tables = new TableNameParser(sql).tables())) {
            boolean sqlParsed = false;
            String parsedSql = sql;
            for (String table : tables) {
                parsedSql = tableNameHandler.process(metaObject, parsedSql, table);
                sqlParsed = true;
            }
            if (sqlParsed) {
                return SqlInfo.newInstance().setSql(parsedSql);
            }
        }
        return null;
    }

    public boolean allowProcess(MetaObject metaObject) {
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicTableNameParser)) {
            return false;
        }
        DynamicTableNameParser other = (DynamicTableNameParser)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicTableNameParser;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "DynamicTableNameParser()";
    }
}

