/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.dto;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.io.Serializable;
import java.util.List;
import org.springframework.util.StringUtils;

public class ResponseDto
implements Serializable {
    private String code;
    private String message;
    private Object result;

    public ResponseDto() {
    }

    public ResponseDto(String code, String message, Object result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    public static ResponseDto success() {
        return new ResponseDto("200", null, null);
    }

    public static ResponseDto error(String message) {
        return new ResponseDto("JANUS005", message, null);
    }

    public boolean isSuccess() {
        return "200".equals(this.code);
    }

    public static ResponseDto fromJsonStr(String jsonStr) {
        ResponseDto responseDto = new ResponseDto();
        if (StringUtils.isEmpty((Object)jsonStr)) {
            return responseDto;
        }
        if (!JSONUtil.isJson((String)jsonStr)) {
            responseDto.setResult(jsonStr);
        } else {
            JSONObject responseJson = JSONUtil.parseObj((String)jsonStr);
            responseDto.setCode(responseJson.getStr((Object)"code"));
            responseDto.setMessage(responseJson.getStr((Object)"message"));
            String result = responseJson.getStr((Object)"result");
            if (StringUtils.isEmpty((Object)result)) {
                result = responseJson.getStr((Object)"infoData");
            }
            if (!StringUtils.isEmpty((Object)result)) {
                if (JSONUtil.isJsonObj((String)result)) {
                    responseDto.setResult(JacksonUtil.getInstance().fromJson(result, Object.class));
                } else if (JSONUtil.isJsonArray((String)result)) {
                    List resultList = JacksonUtil.getInstance().fromJsonToList(result, Object.class);
                    responseDto.setResult(resultList);
                } else {
                    responseDto.setResult(result);
                }
            }
        }
        return responseDto;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getResult() {
        return this.result;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseDto)) {
            return false;
        }
        ResponseDto other = (ResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$result = this.getResult();
        Object other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseDto(code=" + this.getCode() + ", message=" + this.getMessage() + ", result=" + this.getResult() + ")";
    }
}

