/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.http;

import com.xforceplus.apollo.logger.ApolloLoggerFactory;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.commons.dto.R;
import com.xforceplus.janus.commons.dto.ResponseDto;
import com.xforceplus.janus.commons.http.HttpUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class OuterReqUtils {
    public static final String HTTP_STATUS_OK = "200";
    public static final String HTTP_STATUS_ERROR = "500";
    private static final Logger LOGGER = LoggerFactory.getLogger(OuterReqUtils.class);

    public static ResponseDto doPostJson(String url, String json) {
        try {
            return OuterReqUtils.dataParse(HttpUtil.doPostJson(url, json));
        }
        catch (IOException e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, "http\u8bf7\u6c42\u5931\u8d25,{}", new Object[]{url});
            return ResponseDto.error("error" + e.getMessage());
        }
    }

    public static ResponseDto doPostJson(String url, String json, Map<String, String> headers) {
        try {
            return OuterReqUtils.dataParse(HttpUtil.doPostJson(url, json, headers));
        }
        catch (IOException e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, "http\u8bf7\u6c42\u5931\u8d25,{}", new Object[]{url});
            return ResponseDto.error("error" + e.getMessage());
        }
    }

    public static ResponseDto doGet(String url, Map<String, String> param, boolean json) {
        return OuterReqUtils.doGet(url, param, json, null);
    }

    public static ResponseDto doDelete(String url, Map<String, String> headers, Map<String, String> param) {
        try {
            return OuterReqUtils.dataParse(HttpUtil.doDelete(url, headers, param));
        }
        catch (IOException e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, "http\u8bf7\u6c42\u5931\u8d25,{}", new Object[]{url});
            return ResponseDto.error("error" + e.getMessage());
        }
    }

    public static ResponseDto doPut(String url, String json, Map<String, String> headers, Map<String, String> param) {
        try {
            return OuterReqUtils.dataParse(HttpUtil.doPutPatch(url, HttpMethod.PUT, json, headers, param));
        }
        catch (IOException e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, "http\u8bf7\u6c42\u5931\u8d25,{}", new Object[]{url});
            return ResponseDto.error("error" + e.getMessage());
        }
    }

    public static ResponseDto doPatch(String url, String json, Map<String, String> headers, Map<String, String> param) {
        try {
            return OuterReqUtils.dataParse(HttpUtil.doPutPatch(url, HttpMethod.PATCH, json, headers, param));
        }
        catch (IOException e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, "http\u8bf7\u6c42\u5931\u8d25,{}", new Object[]{url});
            return ResponseDto.error("error" + e.getMessage());
        }
    }

    public static ResponseDto doGet(String url, Map<String, String> param, boolean json, Map<String, String> headers) {
        try {
            return OuterReqUtils.dataParse(HttpUtil.doGet(url, param, json, headers));
        }
        catch (IOException e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, "http\u8bf7\u6c42\u5931\u8d25,{}", new Object[]{url});
            return ResponseDto.error("error" + e.getMessage());
        }
    }

    private static ResponseDto dataParse(String res) {
        if (StringUtils.isBlank((String)res)) {
            return ResponseDto.error("\u54cd\u5e94\u6570\u636e\u4f53\u4e3a\u7a7a");
        }
        ResponseDto responseDto = ResponseDto.fromJsonStr(res);
        if (!HTTP_STATUS_OK.equals(responseDto.getCode())) {
            responseDto.setCode(HTTP_STATUS_ERROR);
            responseDto.setResult(res);
        }
        return responseDto;
    }

    public static R doPostJsonr(String url, String json) throws IOException {
        return OuterReqUtils.dataParser(HttpUtil.doPostJson(url, json));
    }

    public static R doGetr(String url, Map<String, String> param, boolean json) {
        try {
            return OuterReqUtils.dataParser(HttpUtil.doGet(url, param, json));
        }
        catch (IOException e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, ErrorUtil.getStackMsg((Exception)e));
            return R.error(-1, "error" + e.getMessage());
        }
    }

    private static R dataParser(String res) {
        if (StringUtils.isBlank((String)res)) {
            return R.error(-1, "\u54cd\u5e94\u6570\u636e\u4f53\u4e3a\u7a7a");
        }
        R r = (R)JacksonUtil.getInstance().fromJson(res, R.class);
        if (null == r) {
            r = R.error(-1, "\u54cd\u5e94\u6570\u636e\u4f53\u683c\u5f0f\u65e0\u6cd5\u89e3\u6790");
        }
        return r;
    }

    public static void main(String[] args) {
    }
}

