/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.util;

import com.xforceplus.janus.commons.exception.RRException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_PATTERN_NO = "yyyyMMdd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_PATTERN_M = "yyyyMM";
    public static final String DATE_PATTERN_H = "yyyyMMddHH";
    public static final String DATE_PATTERN_YMDH = "yyyy-MM-dd HH";

    public static String format(Date date) {
        return DateUtils.format(date, DATE_PATTERN);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        String datePattern = pattern;
        if (StringUtils.isEmpty((String)pattern)) {
            datePattern = DATE_TIME_PATTERN;
        }
        FastDateFormat dateFormat = FastDateFormat.getInstance((String)datePattern);
        return dateFormat.format(date);
    }

    public static Date stringToDate(String strDate, String pattern) {
        if (StringUtils.isBlank((String)strDate)) {
            return null;
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)pattern);
        return fmt.parseLocalDateTime(strDate).toDate();
    }

    public static Date addDateSeconds(Date date, int seconds) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusSeconds(seconds).toDate();
    }

    public static Date addDateMinutes(Date date, int minutes) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusMinutes(minutes).toDate();
    }

    public static Date addDateHours(Date date, int hours) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusHours(hours).toDate();
    }

    public static Date addDateDays(Date date, int days) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusDays(days).toDate();
    }

    public static Date addDateWeeks(Date date, int weeks) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusWeeks(weeks).toDate();
    }

    public static Date addDateMonths(Date date, int months) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusMonths(months).toDate();
    }

    public static Date addDateYears(Date date, int years) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusYears(years).toDate();
    }

    public static Date[] getWeekStartAndEnd(int week) {
        DateTime dateTime = new DateTime();
        LocalDate date = new LocalDate((Object)dateTime.plusWeeks(week));
        date = date.dayOfWeek().withMinimumValue();
        Date beginDate = date.toDate();
        Date endDate = date.plusDays(6).toDate();
        return new Date[]{beginDate, endDate};
    }

    public static String[] getDayStartAndEnd(Date date) {
        String endDate = DateUtils.format(DateUtils.endOfDay(date), DATE_TIME_PATTERN);
        String beginDate = DateUtils.format(DateUtils.beginOfDay(date), DATE_TIME_PATTERN);
        return new String[]{beginDate, endDate};
    }

    public static String[] getHourStartAndEnd(Date date) {
        String beginDate = DateUtils.format(DateUtils.beginOfHour(date), DATE_TIME_PATTERN);
        String endDate = DateUtils.format(DateUtils.endOfHour(date), DATE_TIME_PATTERN);
        return new String[]{beginDate, endDate};
    }

    public static Date beginOfHour(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfHour(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date beginOfDay(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfDay(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }

    public static Calendar calendar(Date date) {
        return DateUtils.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static List<String> getRangeDate(Date beginDate, Date endDate, int field, String format) {
        if (beginDate.after(endDate)) {
            throw new RRException("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f");
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(DateUtils.format(beginDate, format));
        while (beginDate.before(endDate)) {
            Calendar calendar = DateUtils.calendar(beginDate);
            calendar.add(field, 1);
            beginDate = new Date(calendar.getTimeInMillis());
            result.add(DateUtils.format(beginDate, format));
        }
        return result;
    }
}

