/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.util;

import com.google.common.collect.ImmutableMap;
import com.xforceplus.apollo.config.EmailConfig;
import com.xforceplus.apollo.logger.ApolloLoggerFactory;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.commons.http.HttpUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSupport {
    private static final Logger logger = LoggerFactory.getLogger(EmailSupport.class);
    private static final Integer CODE_SUCCESS = 1;
    private String Authentication;
    private String uiaSign;
    private String gatewayUrl;

    public EmailSupport(String authentication, String gatewayUrl, String uiaSign) {
        this.Authentication = authentication;
        this.gatewayUrl = gatewayUrl;
        this.uiaSign = uiaSign;
    }

    public boolean sendEmail(String content, String subject, String receiveEmail) {
        int appId = EmailConfig.getConfig().getIntProperty("appId");
        int tenantId = EmailConfig.getConfig().getIntProperty("tenantId");
        String senderName = EmailConfig.getConfig().getProperty("senderName");
        String action = EmailConfig.getConfig().getProperty("action.message.api.sendEmail");
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("appId", appId);
        requestMap.put("tenantId", tenantId);
        requestMap.put("content", content);
        requestMap.put("subject", subject);
        requestMap.put("senderName", senderName);
        List<String> receiveEmails = Arrays.asList(receiveEmail.split(","));
        if (receiveEmails.size() > 1) {
            receiveEmails = receiveEmails.stream().distinct().collect(Collectors.toList());
            requestMap.put("email", receiveEmails.get(0));
            receiveEmails.remove(0);
            ArrayList<ImmutableMap> rs = new ArrayList<ImmutableMap>();
            int len = receiveEmails.size();
            for (int i = 1; i < len; ++i) {
                rs.add(ImmutableMap.of((Object)"receiver", (Object)receiveEmails.get(i), (Object)"receiverType", (Object)"email"));
            }
            requestMap.put("receiverList", rs);
        } else {
            requestMap.put("email", receiveEmail);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authentication", this.Authentication);
        headers.put("rpcType", "http");
        headers.put("uiaSign", this.uiaSign);
        headers.put("action", action);
        headers.put("tenantId", tenantId + "");
        headers.put("serialNo", "" + System.currentTimeMillis());
        try {
            String result = HttpUtil.doPostJson(this.gatewayUrl, JacksonUtil.getInstance().toJson(requestMap), headers);
            return StringUtils.isNotBlank((String)result) && CODE_SUCCESS.equals(((Map)JacksonUtil.getInstance().fromJson(result, Map.class)).get("code"));
        }
        catch (IOException ex) {
            ApolloLoggerFactory.getFactory().loggerError(logger, ErrorUtil.getStackMsg((Exception)ex));
            return false;
        }
    }
}

