/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.util;

import com.baomidou.mybatisplus.annotation.TableName;
import com.xforceplus.apollo.utils.DateFormatUtil;
import com.xforceplus.janus.commons.datalayer.TableSubMeter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TableUtil {
    public static String getAnnTable(Class clazz) {
        TableName tableName = clazz.getAnnotation(TableName.class);
        if (null == tableName || StringUtils.isBlank((CharSequence)tableName.value())) {
            throw new RuntimeException(String.format("table name is empty:%s", clazz.getSimpleName()));
        }
        return tableName.value();
    }

    public static List<String> getQueryTableName(Class clazz) {
        HashSet<String> tables;
        block16: {
            tables = new HashSet<String>();
            String sourceTable = TableUtil.getAnnTable(clazz);
            try {
                TableSubMeter tableHelper = clazz.getAnnotation(TableSubMeter.class);
                if (null != tableHelper && tableHelper.isSubmeter()) {
                    int forward = tableHelper.forward();
                    String format = tableHelper.formatType();
                    if (StringUtils.isBlank((CharSequence)format)) {
                        format = "yyyyMM";
                    }
                    tables.add(sourceTable + "_" + DateFormatUtil.formatDate((Date)new Date(), (String)format));
                    switch (format) {
                        case "yyyy": {
                            for (int i = 1; i < forward; ++i) {
                                tables.add(sourceTable + "_" + TableUtil.getYear(-i));
                            }
                            break block16;
                        }
                        case "yyyyMMdd": {
                            for (int i = 1; i < forward; ++i) {
                                tables.add(sourceTable + "_" + DateFormatUtil.getDateAfterAddDay((String)DateFormatUtil.getCurrentFormatDateTime(), (int)(-i)).replaceAll("-", ""));
                            }
                            break block16;
                        }
                        default: {
                            for (int i = 1; i < forward; ++i) {
                                tables.add(sourceTable + "_" + DateFormatUtil.getDateAfterAddMonth((String)DateFormatUtil.getCurrentFormatDateTime(), (int)(-i)).replaceAll("-", ""));
                            }
                            break block16;
                        }
                    }
                }
                tables.add(sourceTable);
            }
            catch (Exception e) {
                tables.add(sourceTable);
            }
        }
        return TableUtil.tableDesc(tables);
    }

    public static String getTableName(Class clazz, String date) {
        String tableName = TableUtil.getAnnTable(clazz);
        return tableName + '_' + date;
    }

    private static String getYear(int diff) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, diff);
        Date y = c.getTime();
        return format.format(y);
    }

    private static List<String> tableDesc(Set<String> set) {
        ArrayList<String> news = new ArrayList<String>(set);
        Collections.sort(news, (o1, o2) -> {
            if (o1 == null || o2 == null) {
                return -1;
            }
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            if (o1.compareTo((String)o2) > 0) {
                return -1;
            }
            if (o1.compareTo((String)o2) < 0) {
                return 1;
            }
            if (o1.compareTo((String)o2) == 0) {
                return 0;
            }
            return 0;
        });
        return news;
    }
}

