/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.validator;

import com.xforceplus.janus.commons.util.DateUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang.StringUtils;

@Target(value={ElementType.FIELD, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={DateFormatChecker.class})
public @interface DateFormat {
    public String message() default "\u65e5\u671f\u683c\u5f0f\u975e\u6cd5$format";

    public Class<?>[] groups() default {};

    public String format() default "yyyy-MM-dd";

    public Class<? extends Payload>[] payload() default {};

    public static class DateFormatChecker
    implements ConstraintValidator<DateFormat, String> {
        String formate;

        public void initialize(DateFormat constraintAnnotation) {
            this.formate = constraintAnnotation.format();
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            if (StringUtils.isBlank((String)value)) {
                return true;
            }
            try {
                Date date = DateUtils.stringToDate(value, this.formate);
                return date != null;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

