/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.validator;

import com.xforceplus.apollo.utils.JacksonUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang.StringUtils;

@Target(value={ElementType.FIELD, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={StringJsonChecker.class})
public @interface StringJson {
    public String message() default "\u5b57\u7b26\u4e32\u4e3a\u975e\u6cd5\u7684JSON\u683c\u5f0f";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class StringJsonChecker
    implements ConstraintValidator<StringJson, String> {
        public void initialize(StringJson constraintAnnotation) {
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            if (StringUtils.isBlank((String)value)) {
                return true;
            }
            return JacksonUtil.getInstance().isJson(value);
        }
    }
}

