/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.exception;

import com.xforceplus.apollo.logger.ApolloLoggerFactory;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.janus.commons.dto.R;
import com.xforceplus.janus.commons.exception.RRException;
import com.xforceplus.janus.commons.exception.ValidataException;
import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authz.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class RRExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RRExceptionHandler.class);

    @ResponseStatus(code=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={RRException.class})
    public R handleRRException(RRException e) {
        R r = new R();
        r.put("code", (Object)e.getCode());
        r.put("message", (Object)e.getMessage());
        return r;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public R handleDuplicateKeyException(DuplicateKeyException e) {
        ApolloLoggerFactory.getFactory().loggerError(LOGGER, "\u4e3b\u952e\u51b2\u7a81,{}", new Object[]{ErrorUtil.getStackMsg((Exception)e)});
        return R.error("JANUSDB001", "\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u8bb0\u5f55");
    }

    @ExceptionHandler(value={IncorrectCredentialsException.class})
    public R handleAuthorizationException(IncorrectCredentialsException e) {
        return R.error(HttpStatus.UNAUTHORIZED.value(), "token \u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public R handleAuthorizationException(AuthorizationException e) {
        return R.error(HttpStatus.FORBIDDEN.value(), "\u65e0\u64cd\u4f5c\u6743\u9650");
    }

    @ExceptionHandler(value={Exception.class})
    public R handleException(Exception e) {
        ApolloLoggerFactory.getFactory().loggerError(LOGGER, ErrorUtil.holdExceptionMsg((Exception)e));
        return R.error(e.getMessage());
    }

    @ExceptionHandler(value={ValidataException.class})
    public R handleValidataException(ValidataException e) {
        return R.error(e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public R handleMissServletParameterException(MissingServletRequestParameterException e) {
        return R.error("JANUS3000", String.format("parameter:%s  type:%s \u5fc5\u586b", e.getParameterName(), e.getParameterType()));
    }

    @ExceptionHandler(value={HttpMessageConversionException.class})
    public R handleHttpMessageConversionException(HttpMessageConversionException e) {
        return R.error("JANUS3001", "http \u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u975e\u6cd5\uff0c\u8f6c\u6362\u5931\u8d25" + e.getLocalizedMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public R handleJsonParamException(Exception e, HttpServletRequest request, ServletResponse response) throws IOException {
        R r = R.error("JANUS3000", "\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\u65e0\u6cd5\u8f6c\u6362:" + e.getLocalizedMessage());
        return r;
    }
}

