/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.gavacache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusAbstractLoadingCache<K, V> {
    protected static Logger logger = LoggerFactory.getLogger(JanusAbstractLoadingCache.class);
    private int maximumSize = 1000;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private Date resetTime;
    private long highestSize = 0L;
    private Date highestTime;
    private LoadingCache<K, V> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadingCache<K, V> getCache() {
        if (this.cache == null) {
            JanusAbstractLoadingCache janusAbstractLoadingCache = this;
            synchronized (janusAbstractLoadingCache) {
                if (this.cache == null) {
                    this.cache = CacheBuilder.newBuilder().maximumSize((long)this.maximumSize).expireAfterWrite(this.getExpireAfterWrite(), this.timeUnit).recordStats().build(new CacheLoader<K, V>(){

                        public V load(K key) throws Exception {
                            return JanusAbstractLoadingCache.this.fetchData(key);
                        }
                    });
                    this.resetTime = new Date();
                    this.highestTime = new Date();
                }
            }
        }
        return this.cache;
    }

    protected abstract V fetchData(K var1);

    protected abstract long getExpireAfterWrite();

    protected V getValue(K key) throws ExecutionException {
        Object result = this.getCache().get(key);
        if (this.getCache().size() > this.highestSize) {
            this.highestSize = this.getCache().size();
            this.highestTime = new Date();
        }
        return (V)result;
    }

    public long getHighestSize() {
        return this.highestSize;
    }

    public Date getHighestTime() {
        return this.highestTime;
    }

    public Date getResetTime() {
        return this.resetTime;
    }

    public void setResetTime(Date resetTime) {
        this.resetTime = resetTime;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void invalid(K key) {
        this.getCache().invalidate(key);
    }

    public void setValue(K key, V val) {
        this.getCache().put(key, val);
    }
}

