/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.commons.http;

import com.xforceplus.apollo.logger.ApolloLoggerFactory;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.IOUtil;
import com.xforceplus.apollo.utils.StringUtil;
import com.xforceplus.janus.commons.http.ResponseCus;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.StreamUtils;

public abstract class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECTION_REQUEST_TIMEOUT = 2000;
    private static final int CONNECTION_TIMEOUT = 1000;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    private static HttpClient httpClient;

    public static String doPost(String url) throws IOException {
        return HttpUtil.doPost(url, null);
    }

    public static String doGet(String url, boolean json) throws IOException {
        return HttpUtil.doGet(url, null, json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doDelete(String url, Map<String, String> headers, Map<String, String> params) throws IOException {
        HttpDelete delete = new HttpDelete(HttpUtil.buildQueryUrlWithParams(url, params));
        delete.addHeader("Content-Type", APPLICATION_JSON);
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                delete.addHeader(entry.getKey(), entry.getValue());
            }
        }
        String result = null;
        InputStream instream = null;
        try {
            delete.setConfig(requestConfig);
            HttpResponse response = httpClient.execute((HttpUriRequest)delete);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtil.getStreamAsString(instream, DEFAULT_CHARSET);
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseCus doPutPatchEntire(String url, HttpMethod httpMethod, String json, Map<String, String> headers, Map<String, String> params) throws IOException {
        ResponseCus responseCus = new ResponseCus();
        HttpPut requestBase = null;
        if (HttpMethod.PUT == httpMethod) {
            requestBase = new HttpPut(HttpUtil.buildQueryUrlWithParams(url, params));
        } else if (HttpMethod.PATCH == httpMethod) {
            requestBase = new HttpPatch(HttpUtil.buildQueryUrlWithParams(url, params));
        }
        String result = null;
        InputStream instream = null;
        try {
            requestBase.addHeader("Content-Type", APPLICATION_JSON);
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    requestBase.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                StringEntity se = new StringEntity(json, DEFAULT_CHARSET);
                se.setContentType(CONTENT_TYPE_TEXT_JSON);
                requestBase.setEntity((HttpEntity)se);
            }
            requestBase.setConfig(requestConfig);
            HttpResponse response = httpClient.execute((HttpUriRequest)requestBase);
            HttpEntity entity = response.getEntity();
            responseCus.setStatus(response.getStatusLine().getStatusCode());
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtil.getStreamAsString(instream, DEFAULT_CHARSET);
                EntityUtils.consumeQuietly((HttpEntity)entity);
                responseCus.setBody(result);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    public static String doPutPatch(String url, HttpMethod httpMethod, String json, Map<String, String> headers, Map<String, String> params) throws IOException {
        return HttpUtil.doPutPatchEntire(url, httpMethod, json, headers, params).getBody();
    }

    public static String doPost(String url, Map<String, Object> params) throws IOException {
        List<NameValuePair> pairList = HttpUtil.convertToPair(params);
        return HttpUtil.doPostl(url, pairList);
    }

    private static List<NameValuePair> convertToPair(Map<String, Object> params) {
        ArrayList<NameValuePair> pairList = new ArrayList<NameValuePair>();
        if (MapUtils.isEmpty(params)) {
            return pairList;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            pairList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), (String)entry.getValue()));
        }
        return pairList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostl(String url, List<NameValuePair> pairs) throws IOException {
        String result = null;
        InputStream instream = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(pairs, DEFAULT_CHARSET);
            httpPost.setEntity((HttpEntity)uefEntity);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtil.getStreamAsString(instream, DEFAULT_CHARSET);
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
        finally {
            if (null != instream) {
                instream.close();
            }
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> params, boolean json) throws IOException {
        return HttpUtil.doGet(url, params, json, null);
    }

    public static String doGet(String url, Map<String, String> params, boolean json, Map<String, String> headers) throws IOException {
        ResponseCus responseCus = HttpUtil.doGetEntire(url, params, json, headers);
        return responseCus.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseCus doGetEntire(String url, Map<String, String> params, boolean json, Map<String, String> headers) throws IOException {
        ResponseCus responseCus = new ResponseCus();
        InputStream instream = null;
        try {
            HttpGet httpget = new HttpGet(HttpUtil.buildQueryUrlWithParams(url, params));
            httpget.setConfig(requestConfig);
            if (json) {
                httpget.addHeader("Content-Type", APPLICATION_JSON);
            }
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpget.addHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            responseCus.setStatus(response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                responseCus.setBody(HttpUtil.getStreamAsString(instream, DEFAULT_CHARSET));
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, int timeout) throws IOException {
        String result = null;
        InputStream instream = null;
        try {
            HttpGet httpget = new HttpGet(HttpUtil.buildQueryUrlWithParams(url, params));
            RequestConfig requestConf = RequestConfig.custom().setConnectTimeout(timeout).build();
            httpget.setConfig(requestConf);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtil.getStreamAsString(instream, DEFAULT_CHARSET);
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return result;
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!StringUtil.areNotEmpty((String[])new String[]{entry.getKey(), entry.getValue()})) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), charset));
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        String result = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(stream, charset));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            result = buffer.toString();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{stream});
            IOUtil.closeQuietly((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{stream});
        IOUtil.closeQuietly((Closeable[])new Closeable[]{in});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String http(String url, Map<String, String> params) {
        URL u = null;
        HttpURLConnection con = null;
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                sb.append("&");
            }
            sb.substring(0, sb.length() - 1);
        }
        try {
            u = new URL(url);
            con = (HttpURLConnection)u.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), DEFAULT_CHARSET);
            osw.write(sb.toString());
            osw.flush();
            osw.close();
        }
        catch (Exception e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, ErrorUtil.holdExceptionMsg((Exception)e));
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String temp;
            if (con == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "GBK"));
            while ((temp = br.readLine()) != null) {
                buffer.append(temp);
                buffer.append("\n");
            }
        }
        catch (Exception e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, ErrorUtil.holdExceptionMsg((Exception)e));
        }
        return buffer.toString();
    }

    public static String doPostJson(String url, String json) throws IOException {
        return HttpUtil.doPostJson(url, json, null);
    }

    public static String doPostJson(String url, String json, Map<String, String> headers) throws IOException {
        return HttpUtil.doPostJson(url, json, headers, null);
    }

    public static String doPostJson(String url, String json, Map<String, String> headers, Map<String, String> params) throws IOException {
        ResponseCus results = HttpUtil.doPostJsonEntire(url, json, headers, params);
        return results.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseCus doPostJsonEntire(String url, String json, Map<String, String> headers, Map<String, String> params) throws IOException {
        ResponseCus responseCus = new ResponseCus();
        InputStream instream = null;
        try {
            HttpPost httpPost = new HttpPost(HttpUtil.buildQueryUrlWithParams(url, params));
            httpPost.addHeader("Content-Type", APPLICATION_JSON);
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                StringEntity se = new StringEntity(json, DEFAULT_CHARSET);
                se.setContentType(CONTENT_TYPE_TEXT_JSON);
                httpPost.setEntity((HttpEntity)se);
            }
            httpPost.setConfig(requestConfig);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            responseCus.setStatus(response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                responseCus.setBody(HttpUtil.getStreamAsString(instream, DEFAULT_CHARSET));
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        return responseCus;
    }

    public static ResponseCus doPostForm(String url, Map<String, String> headers, Map<String, String> params) throws IOException {
        ResponseCus responseCus = new ResponseCus();
        InputStream instream = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.addHeader("Content-type", "application/x-www-form-urlencoded;charset=utf-8");
            httpPost.setHeader("Accept", APPLICATION_JSON);
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, DEFAULT_CHARSET));
            httpPost.setConfig(requestConfig);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            responseCus.setStatus(httpResponse.getStatusLine().getStatusCode());
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                instream = httpEntity.getContent();
                responseCus.setBody(HttpUtil.getStreamAsString(instream, DEFAULT_CHARSET));
            }
        }
        catch (Exception ex) {
            IOUtil.closeQuietly((Closeable[])new Closeable[]{instream});
        }
        return responseCus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String multipartRequest(String url, File file) {
        String result;
        block8: {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            CloseableHttpResponse response = null;
            result = null;
            try {
                HttpPost httpPost = new HttpPost(url);
                MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
                mEntityBuilder.addBinaryBody("file", file, ContentType.MULTIPART_FORM_DATA, file.getName());
                mEntityBuilder.setContentType(ContentType.MULTIPART_FORM_DATA);
                httpPost.setEntity(mEntityBuilder.build());
                response = httpclient.execute((HttpUriRequest)httpPost);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    HttpEntity resEntity = response.getEntity();
                    result = EntityUtils.toString((HttpEntity)resEntity);
                    EntityUtils.consume((HttpEntity)resEntity);
                }
                HttpClientUtils.closeQuietly((HttpClient)httpclient);
            }
            catch (ParseException e) {
                ApolloLoggerFactory.getFactory().loggerError(LOGGER, ErrorUtil.holdExceptionMsg((Exception)((Object)e)));
                break block8;
            }
            catch (IOException e2) {
                ApolloLoggerFactory.getFactory().loggerError(LOGGER, ErrorUtil.holdExceptionMsg((Exception)e2));
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                HttpClientUtils.closeQuietly((HttpClient)httpclient);
                HttpClientUtils.closeQuietly(response);
            }
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
        return result;
    }

    public static String postMultipartFormData(String url, Map<String, File[]> form) throws IOException {
        HttpURLConnection connection = null;
        ApolloLoggerFactory.getFactory().loggerInfo(LOGGER, "POST multipart/form-data request: {}", new Object[]{url});
        String boundary = "----WebKitFormBoundary" + System.currentTimeMillis();
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            OutputStream os = connection.getOutputStream();
            for (Map.Entry<String, File[]> entry : form.entrySet()) {
                File[] files;
                String key = entry.getKey();
                for (File file : files = entry.getValue()) {
                    HttpUtil.outputFile(boundary, os, key, file);
                }
            }
            HttpUtil.outputFoot(boundary, os);
            String response = StreamUtils.copyToString((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset());
            ApolloLoggerFactory.getFactory().loggerInfo(LOGGER, "POST multipart/form-data response: {}", new Object[]{response});
            String string = response;
            return string;
        }
        catch (IOException e) {
            ApolloLoggerFactory.getFactory().loggerError(LOGGER, ErrorUtil.getStackMsg((Exception)e));
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static void outputInput(String boundary, OutputStream os, String name, String value) throws IOException {
        os.write(("--" + boundary + "\r\n").getBytes());
        os.write(("Content-Disposition: form-data; name=\"" + name + "\"\r\n").getBytes());
        os.write("\r\n".getBytes());
        os.write(value.getBytes());
        os.write("\r\n".getBytes());
        os.flush();
    }

    private static void outputFile(String boundary, OutputStream os, String name, File value) throws IOException {
        String filename = value.getName();
        FileInputStream is = new FileInputStream(value);
        HttpUtil.outputStream(boundary, os, name, filename, is);
        ((InputStream)is).close();
    }

    private static void outputStream(String boundary, OutputStream os, String name, String filename, InputStream is) throws IOException {
        os.write(("--" + boundary + "\r\n").getBytes());
        os.write(("Content-Disposition: form-data;name=\"" + name + "\"; filename=\"" + filename + "\"\r\n").getBytes());
        os.write("Content-Type: application/octet-stream\r\n".getBytes());
        os.write("\r\n".getBytes());
        StreamUtils.copy((InputStream)is, (OutputStream)os);
        os.write("\r\n".getBytes());
        os.flush();
    }

    private static void outputFoot(String boundary, OutputStream os) throws IOException {
        os.write(("--" + boundary + "--\r\n").getBytes());
        os.flush();
    }

    public static String buildQueryUrlWithParams(String url, Map<String, String> params) throws IOException {
        if (MapUtils.isEmpty(params)) {
            return url;
        }
        StringBuilder urlSb = new StringBuilder(url);
        String urlParam = HttpUtil.buildQuery(params, DEFAULT_CHARSET);
        if (url.contains("?") && url.contains("=")) {
            urlSb.append("&");
        } else {
            urlSb.append("?");
        }
        urlSb.append(urlParam);
        return urlSb.toString();
    }

    static {
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(1000);
        configBuilder.setSocketTimeout(10000);
        configBuilder.setConnectionRequestTimeout(2000);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).build();
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

