package com.xforceplus.janus.flow.cache.config;


import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.TimeUnit;

@Configuration
public class LocalCacheLRUConfig {
    private static final long MAXIMUMSIZE = 1000L;
    private static final long DURATION = 300L;

    @Bean(name = "localCache")
    public Cache<String, Object> loadingCache() {
        Cache<String, Object> cache = CacheBuilder.newBuilder().maximumSize(MAXIMUMSIZE).expireAfterWrite(DURATION, TimeUnit.SECONDS).recordStats().build();
        return cache;
    }


}
